/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class SelectRecipeExamples
extends Recipe {
    private static final String DOCUMENT_EXAMPLE_ANNOTATION_FQN = "org.openrewrite.DocumentExample";
    private static final AnnotationMatcher TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher ISSUE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.Issue");
    private static final AnnotationMatcher DISABLED_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Disabled");
    private static final AnnotationMatcher NESTED_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Nested");
    private static final AnnotationMatcher DOCUMENT_EXAMPLE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.DocumentExample");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER_ALL = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(..)");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER_WITH_SPEC = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(java.util.function.Consumer, org.openrewrite.test.SourceSpecs[])");
    private static final String REWRITE_TEST_FQN = "org.openrewrite.test.RewriteTest";

    public String getDisplayName() {
        return "Automatically select recipe examples from the unit test cases of a recipe";
    }

    public String getDescription() {
        return "Add `@DocumentExample` to the first non-issue and not a disabled unit test of a recipe as an example, if there are not any examples yet.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new UsesType(DOCUMENT_EXAMPLE_ANNOTATION_FQN, Boolean.valueOf(false))), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private int selectedCount = 0;

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getImplements() != null && !classDecl.getImplements().isEmpty() && !TypeUtils.isOfClassType((JavaType)((TypeTree)classDecl.getImplements().get(0)).getType(), (String)SelectRecipeExamples.REWRITE_TEST_FQN)) {
                    return classDecl;
                }
                this.selectedCount = 0;
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (this.selectedCount > 0) {
                    return method;
                }
                List annotations = ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor());
                if (annotations.stream().noneMatch(arg_0 -> ((AnnotationMatcher)TEST_ANNOTATION_MATCHER).matches(arg_0)) || annotations.stream().anyMatch(a -> ISSUE_ANNOTATION_MATCHER.matches(a) || DISABLED_ANNOTATION_MATCHER.matches(a) || DOCUMENT_EXAMPLE_ANNOTATION_MATCHER.matches(a))) {
                    return method;
                }
                J.ClassDeclaration clazz = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
                if (clazz.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)NESTED_ANNOTATION_MATCHER).matches(arg_0))) {
                    return method;
                }
                boolean isAGoodExample = ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean isGood) {
                        if (REWRITE_RUN_METHOD_MATCHER_ALL.matches((MethodCall)method)) {
                            Expression arg;
                            int argIndex = 0;
                            if (REWRITE_RUN_METHOD_MATCHER_WITH_SPEC.matches((MethodCall)method)) {
                                argIndex = 1;
                            }
                            if ((arg = (Expression)method.getArguments().get(argIndex)) instanceof J.MethodInvocation) {
                                J.MethodInvocation methodInvocation = (J.MethodInvocation)arg;
                                methodInvocation.getArguments();
                                if (methodInvocation.getArguments().size() > 1) {
                                    Expression arg0 = (Expression)methodInvocation.getArguments().get(0);
                                    Expression arg1 = (Expression)methodInvocation.getArguments().get(1);
                                    if (SelectRecipeExamples.isStringLiteral(arg0) && SelectRecipeExamples.isStringLiteral(arg1)) {
                                        isGood.set(true);
                                    }
                                }
                            }
                        }
                        return method;
                    }
                }.reduce((Tree)method, (Object)new AtomicBoolean())).get();
                if (!isAGoodExample) {
                    return method;
                }
                this.maybeAddImport(SelectRecipeExamples.DOCUMENT_EXAMPLE_ANNOTATION_FQN);
                ++this.selectedCount;
                return (J.MethodDeclaration)JavaTemplate.builder((String)"@DocumentExample").contextSensitive().imports(new String[]{SelectRecipeExamples.DOCUMENT_EXAMPLE_ANNOTATION_FQN}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build().apply(this.getCursor(), method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        });
    }

    private static boolean isStringLiteral(Expression expression) {
        return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
    }
}

