/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.time.Duration;
import java.util.Comparator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class SetDefaultEstimatedEffortPerOccurrence
extends Recipe {
    public String getDisplayName() {
        return "Set default estimated effort";
    }

    public String getDescription() {
        return "Retrofit recipes with a default estimated effort per occurrence.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.openrewrite.Recipe", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate addMethod = JavaTemplate.builder((String)"@Override public Duration getEstimatedEffortPerOccurrence() {\nreturn Duration.ofMinutes(5);\n}").imports(new String[]{"java.time.Duration"}).build();

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)classDecl.getType());
                if (TypeUtils.isAssignableTo((String)"org.openrewrite.Recipe", (JavaType)type)) {
                    assert (type != null);
                    for (Statement statement : classDecl.getBody().getStatements()) {
                        J.MethodDeclaration method;
                        if (!(statement instanceof J.MethodDeclaration) || !"getEstimatedEffortPerOccurrence".equals((method = (J.MethodDeclaration)statement).getSimpleName())) continue;
                        return classDecl;
                    }
                    this.maybeAddImport("java.time.Duration");
                    try {
                        return (J.ClassDeclaration)this.addMethod.apply(this.getCursor(), classDecl.getBody().getCoordinates().addMethodDeclaration(Comparator.comparing(J.MethodDeclaration::getSimpleName, new RuleBasedCollator("< getDisplayName < getDescription < getEstimatedEffortPerOccurrence < getVisitor"))), new Object[0]);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        });
    }
}

