/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collection;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class IsLiteralNullRecipe
extends Recipe {
    public String getDisplayName() {
        return "Refaster template `IsLiteralNull`";
    }

    public String getDescription() {
        return "Recipe created for the following Refaster template:\n```java\npublic class IsLiteralNull {\n    \n    @BeforeTemplate\n    boolean before(Expression expression) {\n        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == null;\n    }\n    \n    @AfterTemplate\n    boolean after(Expression expression) {\n        return J.Literal.isLiteralValue(expression, null);\n    }\n}\n```\n.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            JavaTemplate before;
            JavaTemplate after;

            public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (this.before == null) {
                    this.before = JavaTemplate.builder((String)"#{expression:any(org.openrewrite.java.tree.Expression)} instanceof org.openrewrite.java.tree.J.Literal && ((org.openrewrite.java.tree.J.Literal)#{expression}).getValue() == null").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                }
                if ((matcher = this.before.matcher(this.getCursor())).find()) {
                    if (this.after == null) {
                        this.after = JavaTemplate.builder((String)"org.openrewrite.java.tree.J.Literal.isLiteralValue(#{expression:any(org.openrewrite.java.tree.Expression)}, null)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                }
                return super.visitBinary(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.tree.Expression", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.tree.J.Literal getValue(..)", true)}), (TreeVisitor)javaVisitor);
    }
}

