/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddOrUpdateAnnotationAttribute;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MissingOptionExample
extends Recipe {
    private static final String ORG_OPENREWRITE_OPTION = "org.openrewrite.Option";

    public String getDisplayName() {
        return "Find missing `@Option` `example` values";
    }

    public String getDescription() {
        return "Find `@Option` annotations that are missing `example` values for documentation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ORG_OPENREWRITE_OPTION, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                JavaType type;
                J.VariableDeclarations variableDeclarations;
                J.Annotation an = super.visitAnnotation(annotation, (Object)ctx);
                if (!TypeUtils.isOfClassType((JavaType)annotation.getType(), (String)MissingOptionExample.ORG_OPENREWRITE_OPTION) || an.getArguments() == null) {
                    return an;
                }
                boolean hasExample = an.getArguments().stream().anyMatch(exp -> {
                    Expression variable;
                    if (exp instanceof J.Assignment && (variable = ((J.Assignment)exp).getVariable()) instanceof J.Identifier) {
                        String simpleName = ((J.Identifier)variable).getSimpleName();
                        return "example".equals(simpleName) || "valid".equals(simpleName);
                    }
                    return false;
                });
                if (hasExample) {
                    return an;
                }
                Cursor parent = this.getCursor().getParent();
                if (parent != null && parent.getValue() instanceof J.VariableDeclarations && (variableDeclarations = (J.VariableDeclarations)parent.getValue()).getTypeExpression() != null && !TypeUtils.isString((JavaType)(type = variableDeclarations.getTypeExpression().getType())) && (type instanceof JavaType.Primitive || type instanceof JavaType.FullyQualified && "java.lang".equals(((JavaType.FullyQualified)type).getPackageName()))) {
                    return an;
                }
                AddOrUpdateAnnotationAttribute addOrUpdateAnnotationAttribute = new AddOrUpdateAnnotationAttribute(MissingOptionExample.ORG_OPENREWRITE_OPTION, "example", "TODO Provide a usage example for the docs", null, Boolean.valueOf(true), Boolean.valueOf(false));
                return (J.Annotation)addOrUpdateAnnotationAttribute.getVisitor().visitNonNull((Tree)an, (Object)ctx, this.getCursor().getParent());
            }
        });
    }
}

