/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes.migrate;

import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.JvmTestSuite;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.template.RecipeDescriptor;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.trait.MethodAccess;
import org.openrewrite.java.trait.VariableAccess;
import org.openrewrite.maven.trait.MavenDependency;
import org.openrewrite.maven.trait.MavenPlugin;
import org.openrewrite.maven.trait.Traits;

@RecipeDescriptor(name="Replace static `Traits` methods with constructor calls", description="Replace the usage of static `Traits` methods with the corresponding constructor calls, as the `Traits` classes were an early abstraction with undesirable import conflicts.")
public class RemoveTraitsUsage {

    @RecipeDescriptor(name="Remove `org.openrewrite.gradle.trait.Traits` usage", description="Removes the usage of static `org.openrewrite.java.gradle.Traits` class and replace with corresponding constructor calls.")
    public static class Gradle {

        @RecipeDescriptor(name="Remove `org.openrewrite.gradle.trait.Traits.jvmTestSuite()` usage", description="Removes the usage of static `org.openrewrite.gradle.trait.Traits.jvmTestSuite()`.")
        public static class JvmTestSuite {
            JvmTestSuite.Matcher before() {
                return org.openrewrite.gradle.trait.Traits.jvmTestSuite();
            }

            JvmTestSuite.Matcher after() {
                return new JvmTestSuite.Matcher();
            }
        }

        @RecipeDescriptor(name="Remove `org.openrewrite.gradle.trait.Traits.gradleDependency()` usage", description="Removes the usage of static `org.openrewrite.gradle.trait.Traits.gradleDependency()`.")
        public static class Dependency {
            GradleDependency.Matcher before() {
                return org.openrewrite.gradle.trait.Traits.gradleDependency();
            }

            GradleDependency.Matcher after() {
                return new GradleDependency.Matcher();
            }
        }
    }

    @RecipeDescriptor(name="Remove `org.openrewrite.maven.trait.Traits` usage", description="Removes the usage of static `org.openrewrite.maven.trait.Traits` class and replace with corresponding constructor calls.")
    public static class Maven {

        @RecipeDescriptor(name="Remove `org.openrewrite.maven.trait.Traits.mavenPlugin()` usage", description="Removes the usage of static `org.openrewrite.maven.trait.Traits.mavenPlugin()`.")
        public static class Plugin {
            MavenPlugin.Matcher before() {
                return Traits.mavenPlugin();
            }

            MavenPlugin.Matcher after() {
                return new MavenPlugin.Matcher();
            }
        }

        @RecipeDescriptor(name="Remove `org.openrewrite.maven.trait.Traits.mavenDependency()` usage", description="Removes the usage of static `org.openrewrite.maven.trait.Traits.mavenDependency()`.")
        public static class Dependency {
            MavenDependency.Matcher before() {
                return Traits.mavenDependency();
            }

            MavenDependency.Matcher after() {
                return new MavenDependency.Matcher();
            }
        }
    }

    @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits` class and replace with corresponding constructor calls.")
    public static class Java {

        @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.annotated(*)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(*)`.")
        public static class Annotated {

            @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.annotated(Class<?>)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(Class<?>)`.")
            public static class ClassType {
                Annotated.Matcher before(Class<?> annotationType) {
                    return org.openrewrite.java.trait.Traits.annotated(annotationType);
                }

                Annotated.Matcher after(Class<?> annotationType) {
                    return new Annotated.Matcher(annotationType);
                }
            }

            @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.annotated(String)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(String)`.")
            public static class StringSignature {
                Annotated.Matcher before(String signature) {
                    return org.openrewrite.java.trait.Traits.annotated((String)signature);
                }

                Annotated.Matcher after(String signature) {
                    return new Annotated.Matcher(signature);
                }
            }

            @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.annotated(AnnotationMatcher)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(AnnotationMatcher)`.")
            public static class AnnotationMatcher {
                Annotated.Matcher before(org.openrewrite.java.AnnotationMatcher matcher) {
                    return org.openrewrite.java.trait.Traits.annotated((org.openrewrite.java.AnnotationMatcher)matcher);
                }

                Annotated.Matcher after(org.openrewrite.java.AnnotationMatcher matcher) {
                    return new Annotated.Matcher(matcher);
                }
            }
        }

        @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.methodAccess(*)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.methodAccess(*)`.")
        public static class MethodAccess {

            @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.methodAccess(String)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.methodAccess(String)`.")
            public static class StringSignature {
                MethodAccess.Matcher before(String signature) {
                    return org.openrewrite.java.trait.Traits.methodAccess((String)signature);
                }

                MethodAccess.Matcher after(String signature) {
                    return new MethodAccess.Matcher(signature);
                }
            }

            @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.methodAccess(MethodMatcher)` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.methodAccess(MethodMatcher)`.")
            public static class MethodMatcher {
                MethodAccess.Matcher before(org.openrewrite.java.MethodMatcher matcher) {
                    return org.openrewrite.java.trait.Traits.methodAccess((org.openrewrite.java.MethodMatcher)matcher);
                }

                MethodAccess.Matcher after(org.openrewrite.java.MethodMatcher matcher) {
                    return new MethodAccess.Matcher(matcher);
                }
            }
        }

        @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.variableAccess()` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.variableAccess()`.")
        public static class VariableAccess {
            VariableAccess.Matcher before() {
                return org.openrewrite.java.trait.Traits.variableAccess();
            }

            VariableAccess.Matcher after() {
                return new VariableAccess.Matcher();
            }
        }

        @RecipeDescriptor(name="Remove `org.openrewrite.java.trait.Traits.literal()` usage", description="Removes the usage of static `org.openrewrite.java.trait.Traits.literal()`.")
        public static class Literal {
            Literal.Matcher before() {
                return org.openrewrite.java.trait.Traits.literal();
            }

            Literal.Matcher after() {
                return new Literal.Matcher();
            }
        }
    }
}

