/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Comparator;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class ReorderTestMethods
extends Recipe {
    private static final String DOCUMENT_EXAMPLE_ANNOTATION_FQN = "org.openrewrite.DocumentExample";
    private static final AnnotationMatcher DOCUMENT_EXAMPLE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.DocumentExample");
    private static final AnnotationMatcher BEFORE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Before*");
    private static final AnnotationMatcher AFTER_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.After*");
    private static final Comparator<J.MethodDeclaration> methodDeclarationComparator = Comparator.comparing(md -> md.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)BEFORE_ANNOTATION_MATCHER).matches(arg_0))).thenComparing(md -> md.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)AFTER_ANNOTATION_MATCHER).matches(arg_0))).thenComparing(md -> "defaults".equals(md.getSimpleName())).thenComparing(md -> md.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)DOCUMENT_EXAMPLE_ANNOTATION_MATCHER).matches(arg_0))).reversed();

    public String getDisplayName() {
        return "Show `@DocumentExample`s first";
    }

    public String getDescription() {
        return "Reorders `RewriteTest` methods to place `defaults` first, followed by any `@DocumentExample`s.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(DOCUMENT_EXAMPLE_ANNOTATION_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                return cd.withBody(cd.getBody().withStatements(cd.getBody().getStatements().stream().sorted((left, right) -> left instanceof J.MethodDeclaration && right instanceof J.MethodDeclaration ? (this.isHelperMethod((J.MethodDeclaration)left) || this.isHelperMethod((J.MethodDeclaration)right) ? 0 : methodDeclarationComparator.compare((J.MethodDeclaration)left, (J.MethodDeclaration)right)) : 0).collect(Collectors.toList())));
            }

            boolean isHelperMethod(J.MethodDeclaration md) {
                return md.hasModifier(J.Modifier.Type.Static) || md.hasModifier(J.Modifier.Type.Private);
            }
        });
    }
}

