/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.AddPlugin;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.xml.tree.Xml;

public final class AddQuarkusMavenPlugin
extends Recipe {
    public String getDisplayName() {
        return "Add Quarkus Maven plugin";
    }

    public String getDescription() {
        return "Adds the Quarkus Maven plugin using the same version as the quarkus-bom in dependency management.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Optional<String> quarkusVersion = this.getResolutionResult().getPom().getRequested().getDependencyManagement().stream().filter(dep -> "io.quarkus.platform".equals(dep.getGroupId()) && "quarkus-bom".equals(dep.getArtifactId())).map(ManagedDependency::getVersion).findFirst();
                if (!quarkusVersion.isPresent()) {
                    return document;
                }
                return (Xml.Document)new AddPlugin("io.quarkus.platform", "quarkus-maven-plugin", quarkusVersion.get(), null, null, null, null).getVisitor().visitNonNull((Tree)document, (Object)ctx);
            }
        };
    }

    @Generated
    public AddQuarkusMavenPlugin() {
    }

    @Generated
    public String toString() {
        return "AddQuarkusMavenPlugin()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddQuarkusMavenPlugin)) {
            return false;
        }
        AddQuarkusMavenPlugin other = (AddQuarkusMavenPlugin)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddQuarkusMavenPlugin;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

