/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RemoveSpringBootParent
extends Recipe {
    public String getDisplayName() {
        return "Remove Spring Boot 3.x parent POM";
    }

    public String getDescription() {
        return "Removes the Spring Boot 3.x starter parent POM from Maven projects.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isSpringBootParent(tag)) {
                    return null;
                }
                return super.visitTag(tag, (Object)ctx);
            }

            private boolean isSpringBootParent(Xml.Tag tag) {
                if (!"parent".equals(tag.getName())) {
                    return false;
                }
                String groupId = tag.getChildValue("groupId").orElse("");
                String artifactId = tag.getChildValue("artifactId").orElse("");
                String version = tag.getChildValue("version").orElse("");
                return "org.springframework.boot".equals(groupId) && "spring-boot-starter-parent".equals(artifactId) && version.startsWith("3.");
            }
        };
    }

    @Generated
    public RemoveSpringBootParent() {
    }

    @Generated
    public String toString() {
        return "RemoveSpringBootParent()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveSpringBootParent)) {
            return false;
        }
        RemoveSpringBootParent other = (RemoveSpringBootParent)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveSpringBootParent;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

