/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ResponseEntityToJaxRsResponse
extends Recipe {
    public static final String RESPONSE_ENTITY_FQN = "org.springframework.http.ResponseEntity";
    public static final String RESPONSE_FQN = "jakarta.ws.rs.core.Response";
    public static final String HTTP_STATUS_FQN = "org.springframework.http.HttpStatus";
    private static final MethodMatcher RESPONSE_ENTITY_OK = new MethodMatcher("org.springframework.http.ResponseEntity ok(..)");
    private static final MethodMatcher RESPONSE_ENTITY_NOT_FOUND = new MethodMatcher("org.springframework.http.ResponseEntity notFound()");
    private static final MethodMatcher RESPONSE_ENTITY_STATUS = new MethodMatcher("org.springframework.http.ResponseEntity status(..)");
    private static final MethodMatcher BODY_METHOD = new MethodMatcher("org.springframework.http.ResponseEntity$* body(..)");

    public String getDisplayName() {
        return "Convert Spring `ResponseEntity` to JAX-RS `Response`";
    }

    public String getDescription() {
        return "Transforms Spring `ResponseEntity` patterns to JAX-RS `Response` API equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(RESPONSE_ENTITY_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final ChangeType changeType = new ChangeType("org.springframework.http.ResponseEntity", "jakarta.ws.rs.core.Response", Boolean.valueOf(false));

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
                this.maybeRemoveImport(ResponseEntityToJaxRsResponse.RESPONSE_ENTITY_FQN);
                this.maybeRemoveImport(ResponseEntityToJaxRsResponse.HTTP_STATUS_FQN);
                this.maybeAddImport(ResponseEntityToJaxRsResponse.RESPONSE_FQN);
                return (J.CompilationUnit)this.changeType.getVisitor().visitNonNull((Tree)c, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                String statusMapping;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (RESPONSE_ENTITY_OK.matches((MethodCall)m)) {
                    if (m.getArguments().isEmpty()) {
                        return (J.MethodInvocation)JavaTemplate.builder((String)"Response.ok()").imports(new String[]{ResponseEntityToJaxRsResponse.RESPONSE_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[0]);
                    }
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Response.ok(#{any()})").imports(new String[]{ResponseEntityToJaxRsResponse.RESPONSE_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getArguments().get(0)});
                }
                if (RESPONSE_ENTITY_NOT_FOUND.matches((MethodCall)m)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Response.status(Response.Status.NOT_FOUND)").imports(new String[]{ResponseEntityToJaxRsResponse.RESPONSE_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[0]);
                }
                if (RESPONSE_ENTITY_STATUS.matches((MethodCall)m) && !m.getArguments().isEmpty() && (statusMapping = this.mapHttpStatusToResponseStatus((Expression)m.getArguments().get(0))) != null) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)("Response.status(" + statusMapping + ")")).imports(new String[]{ResponseEntityToJaxRsResponse.RESPONSE_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[0]);
                }
                if (BODY_METHOD.matches((MethodCall)m)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any()}.entity(#{any()})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect(), m.getArguments().get(0)});
                }
                return m;
            }

            private @Nullable String mapHttpStatusToResponseStatus(Expression statusExpr) {
                if (statusExpr instanceof J.FieldAccess) {
                    String statusName;
                    J.FieldAccess fieldAccess = (J.FieldAccess)statusExpr;
                    switch (statusName = fieldAccess.getSimpleName()) {
                        case "CREATED": 
                        case "NO_CONTENT": 
                        case "NOT_FOUND": 
                        case "BAD_REQUEST": 
                        case "UNAUTHORIZED": 
                        case "FORBIDDEN": 
                        case "INTERNAL_SERVER_ERROR": {
                            return "Response.Status." + statusName;
                        }
                    }
                    return null;
                }
                return null;
            }
        });
    }

    @Generated
    public ResponseEntityToJaxRsResponse() {
    }

    @Generated
    public String toString() {
        return "ResponseEntityToJaxRsResponse()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseEntityToJaxRsResponse)) {
            return false;
        }
        ResponseEntityToJaxRsResponse other = (ResponseEntityToJaxRsResponse)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseEntityToJaxRsResponse;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

