/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public final class SpringApplicationRunToQuarkusRun
extends Recipe {
    private static final MethodMatcher SPRING_APPLICATION_RUN = new MethodMatcher("org.springframework.boot.SpringApplication run(..)", true);

    public String getDisplayName() {
        return "Replace `SpringApplication.run()` with `Quarkus.run()`";
    }

    public String getDescription() {
        return "Replace Spring Boot's `SpringApplication.run()` method calls with Quarkus's `Quarkus.run()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(SPRING_APPLICATION_RUN), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (SPRING_APPLICATION_RUN.matches((MethodCall)mi)) {
                    this.maybeRemoveImport("org.springframework.boot.SpringApplication");
                    this.maybeAddImport("io.quarkus.runtime.Quarkus");
                    J.MethodInvocation quarkusRun = (J.MethodInvocation)JavaTemplate.builder((String)"Quarkus.run()").imports(new String[]{"io.quarkus.runtime.Quarkus"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"quarkus-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[0]);
                    List args = ListUtils.mapFirst((List)mi.getArguments(), arg -> null);
                    return quarkusRun.withArguments(ListUtils.mapFirst((List)args, arg -> (Expression)arg.withPrefix(Space.EMPTY)));
                }
                return mi;
            }
        });
    }

    @Generated
    public SpringApplicationRunToQuarkusRun() {
    }

    @Generated
    public String toString() {
        return "SpringApplicationRunToQuarkusRun()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringApplicationRunToQuarkusRun)) {
            return false;
        }
        SpringApplicationRunToQuarkusRun other = (SpringApplicationRunToQuarkusRun)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringApplicationRunToQuarkusRun;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

