/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ValueToCdiConfigProperty
extends Recipe {
    private static final Pattern VALUE_ANNOTATION_PROPERTY_VALUE = Pattern.compile("[$][{]([^:}]+)(?::([^}]+))?[}]");

    public String getDisplayName() {
        return "Replace Spring `@Value` with CDI `@ConfigProperty`";
    }

    public String getDescription() {
        return "Transform Spring `@Value` annotations to MicroProfile `@ConfigProperty` with proper parameter mapping.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.springframework.beans.factory.annotation.Value", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.springframework.beans.factory.annotation.Value") || a.getArguments() == null || a.getArguments().isEmpty()) {
                    return a;
                }
                this.maybeRemoveImport("org.springframework.beans.factory.annotation.Value");
                this.maybeAddImport("org.eclipse.microprofile.config.inject.ConfigProperty");
                if (!(a.getArguments().get(0) instanceof J.Literal)) {
                    return a;
                }
                J.Literal literal = (J.Literal)a.getArguments().get(0);
                String value = (String)literal.getValue();
                if (value == null) {
                    return a;
                }
                Matcher matcher = VALUE_ANNOTATION_PROPERTY_VALUE.matcher(value);
                if (!matcher.matches()) {
                    return a;
                }
                String propertyKey = matcher.group(1);
                String defaultValue = matcher.group(2);
                String configPropertyTemplate = defaultValue != null ? String.format("@ConfigProperty(name = \"%s\", defaultValue = \"%s\")", propertyKey, defaultValue) : String.format("@ConfigProperty(name = \"%s\")", propertyKey);
                return (J.Annotation)JavaTemplate.builder((String)configPropertyTemplate).imports(new String[]{"org.eclipse.microprofile.config.inject.ConfigProperty"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"microprofile-config-api"})).build().apply(this.getCursor(), a.getCoordinates().replace(), new Object[0]);
            }
        });
    }

    @Generated
    public ValueToCdiConfigProperty() {
    }

    @Generated
    public String toString() {
        return "ValueToCdiConfigProperty()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueToCdiConfigProperty)) {
            return false;
        }
        ValueToCdiConfigProperty other = (ValueToCdiConfigProperty)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValueToCdiConfigProperty;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

