/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class WebToJaxRs
extends Recipe {
    public String getDisplayName() {
        return "Convert Spring Web annotations to JAX-RS";
    }

    public String getDescription() {
        return "Converts Spring Web annotations such as `@RestController`, `@RequestMapping`, `@GetMapping`, etc., to their JAX-RS equivalents like `@Path`, `@GET`, etc.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.bind.annotation.RestController", Boolean.valueOf(false)), new UsesType("org.springframework.stereotype.Controller", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.RequestMapping", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.GetMapping", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.PostMapping", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.PutMapping", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.DeleteMapping", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.PatchMapping", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.PathVariable", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.RequestParam", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.RequestHeader", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.RequestBody", Boolean.valueOf(false)), new UsesType("org.springframework.web.bind.annotation.ResponseBody", Boolean.valueOf(false))}), (TreeVisitor)Repeat.repeatUntilStable((TreeVisitor)new WebToJaxRsVisitor()));
    }

    private static class WebToJaxRsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher REST_CONTROLLER_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.RestController");
        private static final AnnotationMatcher CONTROLLER_MATCHER = new AnnotationMatcher("@org.springframework.stereotype.Controller");
        private static final AnnotationMatcher RESPONSE_BODY_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.ResponseBody");
        private static final AnnotationMatcher REQUEST_MAPPING_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.RequestMapping");
        private static final AnnotationMatcher PATH_VARIABLE_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.PathVariable");
        private static final AnnotationMatcher REQUEST_PARAM_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.RequestParam");
        private static final AnnotationMatcher REQUEST_HEADER_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.RequestHeader");
        private static final AnnotationMatcher REQUEST_BODY_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.RequestBody");
        private static final AnnotationMatcher GET_MAPPING_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.GetMapping");
        private static final AnnotationMatcher POST_MAPPING_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.PostMapping");
        private static final AnnotationMatcher PUT_MAPPING_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.PutMapping");
        private static final AnnotationMatcher DELETE_MAPPING_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.DeleteMapping");
        private static final AnnotationMatcher PATCH_MAPPING_MATCHER = new AnnotationMatcher("@org.springframework.web.bind.annotation.PatchMapping");

        private WebToJaxRsVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
            J.CompilationUnit cu = super.visitCompilationUnit(compilationUnit, (Object)ctx);
            this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(REQUEST_BODY_MATCHER));
            return cu.withClasses(ListUtils.mapFirst((List)cu.getClasses(), cd -> cd.withPrefix(cd.getPrefix().withWhitespace("\n\n")).withLeadingAnnotations(ListUtils.mapFirst((List)cd.getLeadingAnnotations(), ann -> ann.withPrefix(ann.getPrefix().withWhitespace(""))))));
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            boolean hasRestController = false;
            boolean hasController = false;
            boolean hasResponseBody = false;
            boolean hasPath = false;
            boolean hasRequestMapping = false;
            for (J.Annotation annotation : classDecl.getLeadingAnnotations()) {
                if (REST_CONTROLLER_MATCHER.matches(annotation)) {
                    hasRestController = true;
                    continue;
                }
                if (CONTROLLER_MATCHER.matches(annotation)) {
                    hasController = true;
                    continue;
                }
                if (RESPONSE_BODY_MATCHER.matches(annotation)) {
                    hasResponseBody = true;
                    continue;
                }
                if (REQUEST_MAPPING_MATCHER.matches(annotation)) {
                    hasRequestMapping = true;
                    continue;
                }
                if (!"Path".equals(annotation.getSimpleName())) continue;
                hasPath = true;
            }
            if ((hasRestController || hasController && hasResponseBody) && !hasRequestMapping && !hasPath) {
                this.maybeAddImport("jakarta.ws.rs.Path");
                return (J.ClassDeclaration)JavaTemplate.builder((String)"@Path(\"\")").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.Path"}).build().apply(this.getCursor(), cd.getCoordinates().addAnnotation((a1, a2) -> 0), new Object[0]);
            }
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            Expression pathToAdd = null;
            Expression consumesToAdd = null;
            Expression producesToAdd = null;
            boolean hasHttpMethod = false;
            for (J.Annotation annotation : method.getLeadingAnnotations()) {
                if (GET_MAPPING_MATCHER.matches(annotation) || POST_MAPPING_MATCHER.matches(annotation) || PUT_MAPPING_MATCHER.matches(annotation) || DELETE_MAPPING_MATCHER.matches(annotation) || PATCH_MAPPING_MATCHER.matches(annotation)) {
                    pathToAdd = this.extractPathValue(annotation);
                    consumesToAdd = this.extractAttributeValue(annotation, "consumes");
                    producesToAdd = this.extractAttributeValue(annotation, "produces");
                    hasHttpMethod = true;
                    continue;
                }
                if (!REQUEST_MAPPING_MATCHER.matches(annotation)) continue;
                pathToAdd = this.extractPathValue(annotation);
                consumesToAdd = this.extractAttributeValue(annotation, "consumes");
                producesToAdd = this.extractAttributeValue(annotation, "produces");
                hasHttpMethod = true;
            }
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            boolean hasPath = false;
            boolean hasConsumes = false;
            boolean hasProduces = false;
            for (J.Annotation annotation : m.getLeadingAnnotations()) {
                String simpleName = annotation.getSimpleName();
                if ("Path".equals(simpleName)) {
                    hasPath = true;
                    continue;
                }
                if ("Consumes".equals(simpleName)) {
                    hasConsumes = true;
                    continue;
                }
                if (!"Produces".equals(simpleName)) continue;
                hasProduces = true;
            }
            if (hasHttpMethod && pathToAdd != null && !hasPath) {
                this.maybeAddImport("jakarta.ws.rs.Path");
                m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Path(#{any()})").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.Path"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation((a1, a2) -> 0), new Object[]{pathToAdd});
            }
            if (hasHttpMethod && consumesToAdd != null && !hasConsumes) {
                this.maybeAddImport("jakarta.ws.rs.Consumes");
                m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Consumes(#{any()})").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.Consumes"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation((a1, a2) -> 0), new Object[]{consumesToAdd});
            }
            if (hasHttpMethod && producesToAdd != null && !hasProduces) {
                this.maybeAddImport("jakarta.ws.rs.Produces");
                m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Produces(#{any()})").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.Produces"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation((a1, a2) -> 0), new Object[]{producesToAdd});
            }
            return m;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J.Annotation ann = annotation;
            Object parent = this.getCursor().getParentOrThrow().getValue();
            if (parent instanceof J.ClassDeclaration) {
                J.ClassDeclaration cd;
                if (REST_CONTROLLER_MATCHER.matches(ann)) {
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.RestController");
                    return null;
                }
                if (CONTROLLER_MATCHER.matches(ann)) {
                    cd = (J.ClassDeclaration)parent;
                    boolean hasResponseBody = cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)RESPONSE_BODY_MATCHER).matches(arg_0));
                    if (hasResponseBody) {
                        this.maybeRemoveImport("org.springframework.stereotype.Controller");
                        return null;
                    }
                } else if (RESPONSE_BODY_MATCHER.matches(ann)) {
                    cd = (J.ClassDeclaration)parent;
                    boolean hasController = cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)CONTROLLER_MATCHER).matches(arg_0));
                    if (hasController) {
                        this.maybeRemoveImport("org.springframework.web.bind.annotation.ResponseBody");
                        return null;
                    }
                } else if (REQUEST_MAPPING_MATCHER.matches(ann)) {
                    Expression path = this.extractPathValue(ann);
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.RequestMapping");
                    this.maybeAddImport("jakarta.ws.rs.Path");
                    String pathAnnotation = path != null ? "@Path(#{any()})" : "@Path";
                    return (J.Annotation)JavaTemplate.builder((String)pathAnnotation).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.Path"}).build().apply(this.getCursor(), ann.getCoordinates().replace(), new Object[]{path});
                }
            }
            if (parent instanceof J.MethodDeclaration) {
                if (REQUEST_MAPPING_MATCHER.matches(ann)) {
                    String jaxRsAnnotation = this.extractMethodType(ann);
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.RequestMapping");
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.RequestMethod");
                    this.maybeAddImport("jakarta.ws.rs." + jaxRsAnnotation);
                    return (J.Annotation)JavaTemplate.builder((String)("@" + jaxRsAnnotation)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs." + jaxRsAnnotation}).build().apply(this.getCursor(), ann.getCoordinates().replace(), new Object[0]);
                }
                if (GET_MAPPING_MATCHER.matches(ann)) {
                    return this.convertHttpMethodMapping(ann, "GetMapping", "GET", ctx);
                }
                if (POST_MAPPING_MATCHER.matches(ann)) {
                    return this.convertHttpMethodMapping(ann, "PostMapping", "POST", ctx);
                }
                if (PUT_MAPPING_MATCHER.matches(ann)) {
                    return this.convertHttpMethodMapping(ann, "PutMapping", "PUT", ctx);
                }
                if (DELETE_MAPPING_MATCHER.matches(ann)) {
                    return this.convertHttpMethodMapping(ann, "DeleteMapping", "DELETE", ctx);
                }
                if (PATCH_MAPPING_MATCHER.matches(ann)) {
                    return this.convertHttpMethodMapping(ann, "PatchMapping", "PATCH", ctx);
                }
            }
            if (parent instanceof J.VariableDeclarations) {
                String newAnn;
                if (PATH_VARIABLE_MATCHER.matches(ann)) {
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.PathVariable");
                    this.maybeAddImport("jakarta.ws.rs.PathParam");
                    newAnn = "@PathParam";
                    Object[] args = new Object[]{};
                    if (ann.getArguments() != null && !ann.getArguments().isEmpty()) {
                        newAnn = "@PathParam(#{})";
                        args = ann.getArguments().toArray();
                    }
                    return (J.Annotation)JavaTemplate.builder((String)newAnn).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.PathParam"}).build().apply(this.getCursor(), ann.getCoordinates().replace(), args);
                }
                if (REQUEST_PARAM_MATCHER.matches(ann)) {
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.RequestParam");
                    this.maybeAddImport("jakarta.ws.rs.QueryParam");
                    newAnn = "@QueryParam";
                    Object[] args = new Object[]{};
                    if (ann.getArguments() != null && !ann.getArguments().isEmpty()) {
                        newAnn = "@QueryParam(#{})";
                        args = ann.getArguments().toArray();
                    }
                    return (J.Annotation)JavaTemplate.builder((String)newAnn).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.QueryParam"}).build().apply(this.getCursor(), ann.getCoordinates().replace(), args);
                }
                if (REQUEST_HEADER_MATCHER.matches(ann)) {
                    this.maybeRemoveImport("org.springframework.web.bind.annotation.RequestHeader");
                    this.maybeAddImport("jakarta.ws.rs.HeaderParam");
                    newAnn = "@HeaderParam";
                    Object[] args = new Object[]{};
                    if (ann.getArguments() != null && !ann.getArguments().isEmpty()) {
                        newAnn = "@HeaderParam(#{})";
                        args = ann.getArguments().toArray();
                    }
                    return (J.Annotation)JavaTemplate.builder((String)newAnn).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs.HeaderParam"}).build().apply(this.getCursor(), ann.getCoordinates().replace(), args);
                }
            }
            return ann;
        }

        private J.Annotation convertHttpMethodMapping(J.Annotation ann, String springMapping, String jaxRsMethod, ExecutionContext ctx) {
            this.maybeRemoveImport("org.springframework.web.bind.annotation." + springMapping);
            this.maybeAddImport("jakarta.ws.rs." + jaxRsMethod);
            return (J.Annotation)JavaTemplate.builder((String)("@" + jaxRsMethod)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.ws.rs-api"})).imports(new String[]{"jakarta.ws.rs." + jaxRsMethod}).build().apply(this.getCursor(), ann.getCoordinates().replace(), new Object[0]);
        }

        private @Nullable Expression extractPathValue(J.Annotation annotation) {
            return this.extractAttributeValue(annotation, "value", "path");
        }

        private @Nullable Expression extractAttributeValue(J.Annotation annotation, String ... attributeNames) {
            if (annotation.getArguments() != null) {
                for (Expression arg : annotation.getArguments()) {
                    J.Assignment assignment;
                    if (arg instanceof J.Literal) {
                        if (attributeNames.length <= 0 || !"value".equals(attributeNames[0]) && !"path".equals(attributeNames[0])) continue;
                        return arg;
                    }
                    if (!(arg instanceof J.Assignment) || !((assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier)) continue;
                    String name = ((J.Identifier)assignment.getVariable()).getSimpleName();
                    for (String attrName : attributeNames) {
                        if (!attrName.equals(name)) continue;
                        return assignment.getAssignment();
                    }
                }
            }
            return null;
        }

        private String extractMethodType(J.Annotation annotation) {
            if (annotation.getArguments() != null) {
                for (Expression arg : annotation.getArguments()) {
                    J.Assignment assignment;
                    if (!(arg instanceof J.Assignment) || !((assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier) || !"method".equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                    Expression methodExpr = assignment.getAssignment();
                    if (methodExpr instanceof J.FieldAccess) {
                        return ((J.FieldAccess)methodExpr).getSimpleName();
                    }
                    if (!(methodExpr instanceof J.Identifier)) continue;
                    return ((J.Identifier)methodExpr).getSimpleName();
                }
            }
            return "GET";
        }
    }
}

