/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.spring;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.trait.Trait;

public final class SpringBeanToCdiProduces
extends Recipe {
    public static final String BEAN_FQN = "org.springframework.context.annotation.Bean";
    private static final Annotated.Matcher BEAN_MATCHER = new Annotated.Matcher("@org.springframework.context.annotation.Bean");
    public static final String SCOPE_FQN = "org.springframework.context.annotation.Scope";
    private static final Annotated.Matcher SCOPE_MATCHER = new Annotated.Matcher("@org.springframework.context.annotation.Scope");
    public static final String PRODUCES_FQN = "jakarta.enterprise.inject.Produces";
    public static final String APPLICATION_SCOPED_FQN = "jakarta.enterprise.context.ApplicationScoped";
    public static final String CONFIGURABLE_BEAN_FACTORY_FQN = "org.springframework.beans.factory.config.ConfigurableBeanFactory";
    public static final String DEPENDENT_FQN = "jakarta.enterprise.context.Dependent";
    public static final String NAMED_FQN = "jakarta.inject.Named";
    public static final String DEPENDENT = "@Dependent";
    public static final String APPLICATION_SCOPED = "@ApplicationScoped";
    public static final String NAMED = "@Named";

    public String getDisplayName() {
        return "Replace Spring `@Bean` with CDI `@Produces`";
    }

    public String getDescription() {
        return "Transform Spring `@Bean` methods to CDI `@Produces` methods with appropriate scope annotations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(BEAN_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                Optional annotated = BEAN_MATCHER.lower(this.getCursor()).findFirst();
                if (!annotated.isPresent()) {
                    return m;
                }
                Annotated beanAnnotation = (Annotated)annotated.get();
                this.maybeRemoveImport(SpringBeanToCdiProduces.BEAN_FQN);
                this.maybeRemoveImport(SpringBeanToCdiProduces.SCOPE_FQN);
                this.maybeRemoveImport(SpringBeanToCdiProduces.CONFIGURABLE_BEAN_FACTORY_FQN);
                this.maybeAddImport(SpringBeanToCdiProduces.PRODUCES_FQN);
                this.maybeAddImport(SpringBeanToCdiProduces.APPLICATION_SCOPED_FQN);
                this.maybeAddImport(SpringBeanToCdiProduces.NAMED_FQN);
                this.maybeAddImport(SpringBeanToCdiProduces.DEPENDENT_FQN);
                String template = this.createTemplate(beanAnnotation.getDefaultAttribute("name").map(Literal::getString).orElse(null), this.determineCdiScope(SCOPE_MATCHER.lower(this.getCursor()).findFirst().map(Trait::getTree).orElse(null)));
                return (J.MethodDeclaration)JavaTemplate.builder((String)template).imports(new String[]{SpringBeanToCdiProduces.PRODUCES_FQN, SpringBeanToCdiProduces.APPLICATION_SCOPED_FQN, SpringBeanToCdiProduces.DEPENDENT_FQN, SpringBeanToCdiProduces.NAMED_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.enterprise.cdi-api", "jakarta.inject-api"})).build().apply(this.getCursor(), m.getCoordinates().replaceAnnotations(), new Object[0]);
            }

            private String createTemplate(@Nullable String beanName, @Nullable String scopeToAdd) {
                StringBuilder templateBuilder = new StringBuilder("@Produces\n");
                if (beanName != null) {
                    templateBuilder.append("@Named(\"").append(beanName).append("\")\n");
                }
                if (scopeToAdd != null) {
                    templateBuilder.append(scopeToAdd);
                } else {
                    templateBuilder.append(SpringBeanToCdiProduces.APPLICATION_SCOPED);
                }
                return templateBuilder.toString();
            }

            private @Nullable String determineCdiScope(// Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.Annotation scopeAnnotation) {
                if (scopeAnnotation == null || scopeAnnotation.getArguments() == null || scopeAnnotation.getArguments().isEmpty()) {
                    return null;
                }
                Expression arg = (Expression)scopeAnnotation.getArguments().get(0);
                String scopeValue = null;
                if (arg instanceof J.Literal) {
                    scopeValue = (String)((J.Literal)arg).getValue();
                } else if (arg instanceof J.FieldAccess) {
                    scopeValue = ((J.FieldAccess)arg).getSimpleName();
                }
                return scopeValue != null && scopeValue.toLowerCase().contains("prototype") ? SpringBeanToCdiProduces.DEPENDENT : SpringBeanToCdiProduces.APPLICATION_SCOPED;
            }
        });
    }

    @Generated
    public SpringBeanToCdiProduces() {
    }

    @Generated
    public String toString() {
        return "SpringBeanToCdiProduces()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringBeanToCdiProduces)) {
            return false;
        }
        SpringBeanToCdiProduces other = (SpringBeanToCdiProduces)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringBeanToCdiProduces;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

