/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.spring.boot2;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AddField;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.FillTypeAttributions;
import org.openrewrite.java.GenerateGetter;
import org.openrewrite.java.GenerateSetter;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@AutoConfigure
public class ValueToConfigurationProperties
extends JavaRefactorVisitor {
    private static final String valueAnnotationSignature = "@org.springframework.beans.factory.annotation.Value";
    private static final String configurationPropertiesFqn = "org.springframework.boot.context.properties.ConfigurationProperties";
    private static final String configurationPropertiesSignature = "@org.springframework.boot.context.properties.ConfigurationProperties";
    private static final JavaType.Class configurationPropertiesAnnotationType = JavaType.Class.build((String)"org.springframework.boot.context.properties.ConfigurationProperties", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(JavaType.Class.build((String)"java.lang.annotation.Annotation")), Collections.emptyList(), null);
    private static final String springBootApplicationSignature = "@org.springframework.boot.autoconfigure.SpringBootApplication";
    PrefixParentNode prefixTree = PrefixTree.build();
    J.CompilationUnit springBootApplication;
    private boolean configClassesGenerated = false;
    JavaParser jp;
    private Map<String, J.CompilationUnit> generatedClasses;

    public ValueToConfigurationProperties() {
        this.setCursoringOn();
    }

    public J visitCompilationUnit(J.CompilationUnit cu) {
        if (this.configClassesGenerated && this.springBootApplication != null) {
            this.andThen((RefactorVisitor)new PopulateConfigurationPropertiesClasses());
            this.andThen((RefactorVisitor)new UpdateReferences());
            this.andThen((RefactorVisitor)new RemoveValueAnnotations());
        }
        return super.visitCompilationUnit(cu);
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        if (!this.configClassesGenerated) {
            classDecl.getFields().forEach(this.prefixTree::put);
            classDecl.getMethods().forEach(this.prefixTree::put);
            if (classDecl.findAnnotations(springBootApplicationSignature).size() > 0) {
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
                assert (cu != null);
                this.springBootApplication = cu;
                this.jp = cu.buildParser(new String[0]);
            }
        }
        return super.visitClassDecl(classDecl);
    }

    public Collection<SourceFile> generate() {
        if (!this.configClassesGenerated && this.springBootApplication != null) {
            this.generatedClasses = new HashMap<String, J.CompilationUnit>();
            this.configClassesGenerated = true;
            return this.prefixTree.getLongestCommonPrefixes().stream().map(commonPrefix -> {
                String className = this.prefixTree.get((List<String>)commonPrefix).getEnclosingClassName();
                String peckage = this.springBootApplication.getPackageDecl() == null ? "" : this.springBootApplication.getPackageDecl().printTrimmed() + ";\n\n";
                String newClassText = peckage + "import org.springframework.boot.context.properties.ConfigurationProperties;\n\n@ConfigurationProperties(\"" + String.join((CharSequence)".", commonPrefix) + "\")\npublic class " + className + " {\n}\n";
                Path parentDir = Paths.get(this.springBootApplication.getSourcePath().toString(), new String[0]).getParent();
                Path sourcePath = parentDir == null ? Paths.get(className + ".java", new String[0]) : parentDir.resolve(className + ".java");
                J.CompilationUnit cu = ValueToConfigurationProperties.fillConfigurationPropertiesTypeAttribution(((J.CompilationUnit)this.jp.reset().parse(new String[]{newClassText}).get(0)).withSourcePath(sourcePath.toString()));
                this.generatedClasses.put(className, cu);
                return cu;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static J.CompilationUnit fillConfigurationPropertiesTypeAttribution(J.CompilationUnit cu) {
        return new FillTypeAttributions(new JavaType.Class[]{configurationPropertiesAnnotationType}).visitCompilationUnit(cu);
    }

    private static J.Block<Statement> getBodyOrEmptyBlock(J.MethodDecl methodDecl) {
        J.Block result = methodDecl.getBody();
        if (result == null) {
            result = new J.Block(Tree.randomId(), null, new ArrayList(), Formatting.EMPTY, new J.Block.End(Tree.randomId(), Formatting.EMPTY));
        }
        return result;
    }

    private static String getValueValue(J.Annotation value) {
        assert (value.getArgs() != null);
        String valueValue = (String)((J.Literal)value.getArgs().getArgs().get(0)).getValue();
        assert (valueValue != null);
        valueValue = valueValue.replace("${", "").replace("}", "");
        valueValue = Arrays.stream(valueValue.split("-")).map(part -> Character.toUpperCase(part.charAt(0)) + part.substring(1)).collect(Collectors.joining(""));
        return Character.toLowerCase(valueValue.charAt(0)) + valueValue.substring(1);
    }

    static class PrefixParentNode
    implements PrefixTree {
        final String name;
        final Map<String, PrefixTree> children = new HashMap<String, PrefixTree>();
        final PrefixParentNode parent;

        private PrefixParentNode(PrefixParentNode parent, String name) {
            this.name = name;
            this.parent = parent;
        }

        PrefixTree buildChild(List<String> pathSegments, JavaType type) {
            if (pathSegments.size() == 0) {
                throw new IllegalArgumentException("pathSegments may not be null");
            }
            String nodeName = pathSegments.get(0);
            List<String> remainingSegments = pathSegments.subList(1, pathSegments.size());
            if (remainingSegments.size() == 0) {
                return new PrefixTerminalNode(this, nodeName, type);
            }
            PrefixParentNode intermediateNode = new PrefixParentNode(this, nodeName);
            PrefixTree child = intermediateNode.buildChild(remainingSegments, type);
            intermediateNode.children.put(child.getName(), child);
            return intermediateNode;
        }

        void put(J.VariableDecls field) {
            List valueAnnotations = field.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature);
            if (valueAnnotations.size() == 0) {
                return;
            }
            J.Annotation valueAnnotation = (J.Annotation)valueAnnotations.get(0);
            String path = ValueToConfigurationProperties.getValueValue(valueAnnotation);
            List<String> pathSegments = Arrays.asList(path.split("\\."));
            if (field.getTypeExpr() != null) {
                this.put(pathSegments, field.getTypeExpr().getType());
            }
        }

        PrefixTerminalNode get(J.VariableDecls field) {
            List valueAnnotations = field.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature);
            if (valueAnnotations.size() == 0) {
                return null;
            }
            J.Annotation valueAnnotation = (J.Annotation)valueAnnotations.get(0);
            String path = ValueToConfigurationProperties.getValueValue(valueAnnotation);
            return (PrefixTerminalNode)this.get(Arrays.asList(path.split("\\.")));
        }

        void put(J.MethodDecl methodDecl) {
            methodDecl.getParams().getParams().stream().filter(param -> param instanceof J.VariableDecls).map(J.VariableDecls.class::cast).filter(param -> param.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).size() > 0).forEach(param -> {
                if (param.getTypeExpr() != null) {
                    J.Annotation valueAnnotation = (J.Annotation)param.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).get(0);
                    List<String> pathSegments = Arrays.asList(ValueToConfigurationProperties.getValueValue(valueAnnotation).split("\\."));
                    this.put(pathSegments, param.getTypeExpr().getType());
                }
            });
        }

        @Override
        public PrefixTree put(List<String> pathSegments, JavaType type) {
            if (pathSegments == null) {
                throw new IllegalArgumentException("pathSegments may not be null");
            }
            if (pathSegments.size() == 0) {
                throw new IllegalArgumentException("pathSegments may not be empty");
            }
            String nodeName = pathSegments.get(0);
            if (this.children.containsKey(nodeName)) {
                PrefixTree existingNode = this.children.get(nodeName);
                existingNode.put(pathSegments.subList(1, pathSegments.size()), type);
            } else {
                this.children.put(nodeName, this.buildChild(pathSegments, type));
            }
            return this;
        }

        @Override
        public PrefixTree get(List<String> pathSegments) {
            if (pathSegments == null) {
                throw new IllegalArgumentException("pathSegments may not be null");
            }
            if (pathSegments.size() == 0) {
                return this;
            }
            String nodeName = pathSegments.get(0);
            List<String> remainingSegments = pathSegments.subList(1, pathSegments.size());
            if (this.children.containsKey(nodeName)) {
                return this.children.get(nodeName).get(remainingSegments);
            }
            return null;
        }

        @Override
        public PrefixParentNode getParent() {
            return this.parent;
        }

        @Override
        public String getEnclosingClassName() {
            if (this.isRoot()) {
                return "";
            }
            if (this.isPartOfCommonPrefix()) {
                String extra = "";
                if (this.children.size() > 1 || !this.children.values().stream().allMatch(it -> it instanceof PrefixParentNode && it.isPartOfCommonPrefix())) {
                    extra = "Configuration";
                }
                return this.getParent().getEnclosingClassName() + StringUtils.capitalize((String)this.getName()) + extra;
            }
            return this.getParent().getEnclosingClassName();
        }

        @Override
        public String getInitializingExpression() {
            if (this.isRoot()) {
                return "";
            }
            if (this.isPartOfCommonPrefix()) {
                String extra = "";
                String resultName = this.parent.getInitializingExpression() + StringUtils.capitalize((String)this.name);
                if (this.children.size() > 1 || !this.children.values().stream().allMatch(it -> it instanceof PrefixParentNode && it.isPartOfCommonPrefix())) {
                    resultName = StringUtils.uncapitalize((String)resultName);
                    extra = "Configuration";
                }
                return resultName + extra;
            }
            return this.getParent().getInitializingExpression() + ".get" + StringUtils.capitalize((String)this.name) + "()";
        }

        @Override
        public boolean isPartOfCommonPrefix() {
            if (this.isRoot() || this.parent.isRoot()) {
                return true;
            }
            return this.parent.isPartOfCommonPrefix() && this.parent.children.size() == 1 && this.parent.children.values().iterator().next() == this;
        }

        public boolean allChildrenTerminal() {
            return this.children.values().stream().allMatch(it -> it instanceof PrefixTerminalNode);
        }

        public boolean onlyChildIsParentNode() {
            return this.children.size() == 1 && this.children.values().iterator().next() instanceof PrefixParentNode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public List<List<String>> getLongestCommonPrefixes() {
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (PrefixTree subtree : this.children.values()) {
                if (subtree instanceof PrefixParentNode) {
                    ArrayList<String> intermediate = new ArrayList<String>();
                    this.getUntilTerminalOrMultipleChildren(intermediate, (PrefixParentNode)subtree);
                    result.add(intermediate);
                    continue;
                }
                List<String> root = Collections.singletonList("root");
                if (result.contains(root)) continue;
                result.add(root);
            }
            return result;
        }

        private void getUntilTerminalOrMultipleChildren(List<String> resultSoFar, PrefixParentNode parentNode) {
            PrefixTree node = parentNode;
            while (node instanceof PrefixParentNode) {
                resultSoFar.add(node.getName());
                ArrayList<PrefixTree> children = new ArrayList<PrefixTree>(node.children.values());
                node = (PrefixTree)children.get(0);
                if (children.size() == 1 && children.get(0) instanceof PrefixParentNode) continue;
            }
        }
    }

    static class PrefixTerminalNode
    implements PrefixTree {
        final String name;
        final PrefixParentNode parent;
        final JavaType type;

        public PrefixTerminalNode(PrefixParentNode parent, String name, JavaType type) {
            this.name = name;
            this.parent = parent;
            this.type = type;
        }

        @Override
        public PrefixTree put(List<String> pathSegments, JavaType type) {
            if (pathSegments == null) {
                throw new IllegalArgumentException("pathSegments may not be null");
            }
            if (type != null && this.type != type) {
                throw new IllegalArgumentException("terminal node cannot have two types. type is currently recorded as \"" + this.type.toTypeTree().printTrimmed() + "\", cannot reassign it to \"" + type.toTypeTree().printTrimmed());
            }
            if (pathSegments.size() > 1) {
                throw new IllegalArgumentException("Cannot add new path segment to terminal node");
            }
            return this;
        }

        @Override
        public PrefixTree get(List<String> pathSegments) {
            if (pathSegments == null) {
                throw new IllegalArgumentException("pathSegments may not be null");
            }
            if (pathSegments.size() == 0) {
                return this;
            }
            if (pathSegments.size() == 1 && pathSegments.get(0).equals(this.name)) {
                return this;
            }
            throw new IllegalArgumentException("Terminal node \"" + this.name + "\" does not match requested path \"" + String.join((CharSequence)".", pathSegments) + "\"");
        }

        @Override
        public PrefixParentNode getParent() {
            return this.parent;
        }

        @Override
        public String getEnclosingClassName() {
            return this.parent.getEnclosingClassName();
        }

        @Override
        public String getInitializingExpression() {
            return this.parent.getInitializingExpression() + ".get" + StringUtils.capitalize((String)this.name) + "()";
        }

        @Override
        public boolean isPartOfCommonPrefix() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    static interface PrefixTree {
        public String getName();

        public PrefixTree put(List<String> var1, JavaType var2);

        default public PrefixTree get(String path) {
            return this.get(Arrays.asList(path.split("\\.")));
        }

        public PrefixTree get(List<String> var1);

        public PrefixParentNode getParent();

        default public boolean isRoot() {
            return this.getParent() == null;
        }

        public String getEnclosingClassName();

        public String getInitializingExpression();

        public boolean isPartOfCommonPrefix();

        default public String getFullPath() {
            if (this.isRoot()) {
                return "";
            }
            if (this.getParent().isRoot()) {
                return this.getName();
            }
            return this.getParent().getFullPath() + "." + this.getName();
        }

        public static PrefixParentNode build() {
            return new PrefixParentNode(null, "root");
        }
    }

    private class RemoveValueAnnotations
    extends JavaRefactorVisitor {
        private RemoveValueAnnotations() {
        }

        public J visitMultiVariable(J.VariableDecls multiVariable) {
            J.VariableDecls mv = (J.VariableDecls)this.refactor((Tree)multiVariable, x$0 -> super.visitMultiVariable(x$0));
            List valueAnnotations = mv.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature);
            if (valueAnnotations.size() > 0) {
                List otherAnnotations = mv.getAnnotations();
                otherAnnotations.removeAll(valueAnnotations);
                mv = mv.withAnnotations(otherAnnotations);
            }
            return mv;
        }

        public J visitMethod(J.MethodDecl method) {
            J.MethodDecl m = (J.MethodDecl)this.refactor((Tree)method, x$0 -> super.visitMethod(x$0));
            if (m.getReturnTypeExpr() == null) {
                List argsWithoutValueAnnotations = m.getParams().getParams().stream().map(it -> {
                    if (it instanceof J.VariableDecls) {
                        J.VariableDecls param = (J.VariableDecls)it;
                        List valueAnnotations = param.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature);
                        List otherAnnotations = param.getAnnotations();
                        otherAnnotations.removeAll(valueAnnotations);
                        return param.withAnnotations(otherAnnotations);
                    }
                    return it;
                }).collect(Collectors.toList());
                m = m.withParams(m.getParams().withParams(argsWithoutValueAnnotations));
            }
            return m;
        }
    }

    private class UpdateReferences
    extends JavaRefactorVisitor {
        private UpdateReferences() {
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl cd = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
            List valueAnnotatedFields = cd.getFields().stream().filter(it -> it.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).size() > 0).collect(Collectors.toList());
            List valueAnnotatedConstructors = cd.getMethods().stream().filter(it -> it.getReturnTypeExpr() == null).filter(it -> it.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).size() > 0).collect(Collectors.toList());
            if (valueAnnotatedFields.size() > 0 || valueAnnotatedConstructors.size() > 0) {
                this.andThen((RefactorVisitor)new Scoped(cd, valueAnnotatedFields, valueAnnotatedConstructors));
            }
            return cd;
        }

        private class Scoped
        extends JavaRefactorVisitor {
            final J.ClassDecl scope;
            final List<J.VariableDecls> valueAnnotatedFields;
            final List<J.MethodDecl> valueAnnotatedConstructors;

            private Scoped(J.ClassDecl scope, List<J.VariableDecls> valueAnnotatedFields, List<J.MethodDecl> valueAnnotatedConstructors) {
                this.scope = scope;
                this.valueAnnotatedFields = valueAnnotatedFields;
                this.valueAnnotatedConstructors = valueAnnotatedConstructors;
                this.setCursoringOn();
            }

            public J visitCompilationUnit(J.CompilationUnit cu) {
                return super.visitCompilationUnit(cu);
            }

            public J visitClassDecl(J.ClassDecl classDecl) {
                J.ClassDecl cd = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
                if (!this.scope.isScope((Tree)cd)) {
                    return cd;
                }
                List<J.MethodDecl> constructors = cd.getMethods().stream().filter(it -> it.getReturnTypeExpr() == null).collect(Collectors.toList());
                List bodyStatementsWithoutConstructors = cd.getBody().getStatements();
                bodyStatementsWithoutConstructors.removeAll(constructors);
                if (constructors.size() == 0) {
                    J.MethodDecl newConstructor = this.treeBuilder.buildMethodDeclaration(cd, "\npublic " + cd.getSimpleName() + "() {\n}\n\n", new JavaType[0]);
                    this.andThen((RefactorVisitor)new AutoFormat(new J[]{newConstructor}));
                    List withNewConstructor = cd.getBody().getStatements();
                    withNewConstructor.add(0, newConstructor);
                    cd = cd.withBody(cd.getBody().withStatements(withNewConstructor));
                    constructors.add(newConstructor);
                }
                List prefixes = Stream.concat(this.valueAnnotatedFields.stream().flatMap(field -> field.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).stream()), this.valueAnnotatedConstructors.stream().flatMap(constructor -> constructor.getParams().getParams().stream().filter(decl -> decl instanceof J.VariableDecls).map(J.VariableDecls.class::cast).flatMap(decl -> decl.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).stream()))).filter(Objects::nonNull).map(x$0 -> ValueToConfigurationProperties.getValueValue(x$0)).distinct().map(it -> ValueToConfigurationProperties.this.prefixTree.get((String)it)).collect(Collectors.toList());
                List configPropsCompilationUnits = prefixes.stream().map(PrefixTree::getEnclosingClassName).distinct().map(ValueToConfigurationProperties.this.generatedClasses::get).collect(Collectors.toList());
                configPropsCompilationUnits.stream().map(cu -> ((J.ClassDecl)cu.getClasses().get(0)).getType()).filter(Objects::nonNull).map(JavaType.FullyQualified::getFullyQualifiedName).forEach(arg_0 -> ((Scoped)this).maybeAddImport(arg_0));
                J.ClassDecl finalCd = cd;
                constructors = constructors.stream().map(constructor -> {
                    for (J.CompilationUnit configPropsCu : configPropsCompilationUnits) {
                        J.MethodDecl.Parameters parameters = constructor.getParams();
                        List parameterStatements = parameters.getParams();
                        J.ClassDecl configPropsClass = (J.ClassDecl)configPropsCu.getClasses().get(0);
                        J.VariableDecls newParam = this.treeBuilder.buildFieldDeclaration(finalCd, configPropsClass.getSimpleName() + " " + StringUtils.uncapitalize((String)(configPropsClass.getSimpleName() + ";")), new JavaType[]{configPropsClass.getType()}).withFormatting(Formatting.format((String)" "));
                        parameterStatements.add(newParam);
                        parameters = parameters.withParams(parameterStatements);
                        if (constructor.getModifiers().size() > 0) {
                            constructor = constructor.withName(constructor.getName().withFormatting(Formatting.format((String)" ")));
                        }
                        constructor = constructor.withParams(parameters);
                    }
                    return constructor;
                }).map(constructor -> {
                    J.MethodDecl.Parameters parameters = constructor.getParams();
                    List valueAnnotatedParams = parameters.getParams().stream().filter(param -> param instanceof J.VariableDecls).map(J.VariableDecls.class::cast).filter(param -> param.findAnnotations(ValueToConfigurationProperties.valueAnnotationSignature).size() > 0).collect(Collectors.toList());
                    List assignmentStatementsToAdd = valueAnnotatedParams.stream().map(param -> {
                        PrefixTerminalNode node = ValueToConfigurationProperties.this.prefixTree.get((J.VariableDecls)param);
                        String initializingExpression = node.getInitializingExpression();
                        assert (param.getTypeExpr() != null);
                        return (J.VariableDecls)this.treeBuilder.buildSnippet(this.getCursor(), param.getTypeExpr().print() + " " + ((J.VariableDecls.NamedVar)param.getVars().get(0)).getSimpleName() + " = " + initializingExpression + ";", new JavaType[]{param.getTypeAsClass()}).get(0);
                    }).collect(Collectors.toList());
                    J.Block body = ValueToConfigurationProperties.getBodyOrEmptyBlock(constructor);
                    List statements = body.getStatements();
                    for (J.VariableDecls statementToAdd : assignmentStatementsToAdd) {
                        statements.add(0, statementToAdd);
                    }
                    constructor = constructor.withBody(body.withStatements(statements));
                    List withoutValueParams = parameters.getParams();
                    withoutValueParams.removeAll(valueAnnotatedParams);
                    return constructor.withParams(parameters.withParams(withoutValueParams));
                }).map(constructor -> {
                    J.Block body = ValueToConfigurationProperties.getBodyOrEmptyBlock(constructor);
                    List statements = body.getStatements();
                    for (J.VariableDecls field : this.valueAnnotatedFields) {
                        PrefixTerminalNode node = ValueToConfigurationProperties.this.prefixTree.get(field);
                        String initializingExpression = node.getInitializingExpression();
                        J.Assign assignment = (J.Assign)this.treeBuilder.buildSnippet(this.getCursor(), "this." + ((J.VariableDecls.NamedVar)field.getVars().get(0)).getSimpleName() + " = " + initializingExpression + ";", new JavaType[]{field.getTypeExpr().getType()}).get(0);
                        statements.add(assignment);
                    }
                    body = body.withStatements(statements).withEnd((J.Block.End)body.getEnd().withPrefix("\n"));
                    return constructor.withBody(body);
                }).collect(Collectors.toList());
                constructors.forEach(it -> this.andThen((RefactorVisitor)new AutoFormat(new J[]{it})));
                bodyStatementsWithoutConstructors.addAll(0, constructors);
                cd = cd.withBody(cd.getBody().withStatements(bodyStatementsWithoutConstructors));
                return cd;
            }
        }
    }

    private class PopulateConfigurationPropertiesClasses
    extends JavaRefactorVisitor {
        private PopulateConfigurationPropertiesClasses() {
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl cd = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
            List configPropsAnnotations = cd.findAnnotations(ValueToConfigurationProperties.configurationPropertiesSignature);
            if (configPropsAnnotations.size() > 0) {
                J.Annotation configPropsAnnotation = (J.Annotation)configPropsAnnotations.get(0);
                if (configPropsAnnotation.getArgs() == null) {
                    return cd;
                }
                String configPropsPrefix = (String)((J.Literal)configPropsAnnotation.getArgs().getArgs().get(0)).getValue();
                if (configPropsPrefix == null) {
                    return cd;
                }
                PrefixParentNode treeForConfigPropsClass = (PrefixParentNode)ValueToConfigurationProperties.this.prefixTree.get(configPropsPrefix);
                for (PrefixTree pt : treeForConfigPropsClass.children.values()) {
                    this.generateClassesFieldsGettersSetters(cd, pt);
                }
            }
            return cd;
        }

        private void generateClassesFieldsGettersSetters(J.ClassDecl cd, PrefixTree pt) {
            if (pt instanceof PrefixTerminalNode) {
                PrefixTerminalNode node = (PrefixTerminalNode)pt;
                String fieldName = node.name;
                String fieldTypeExpr = node.type.toTypeTree().printTrimmed();
                this.andThen((RefactorVisitor)new AddField.Scoped(cd, Collections.singletonList(new J.Modifier.Private(Tree.randomId(), Formatting.EMPTY)), fieldTypeExpr, fieldName, null));
                this.andThen((RefactorVisitor)new GenerateGetter.Scoped(cd, fieldName));
                this.andThen((RefactorVisitor)new GenerateSetter.Scoped(cd, fieldName));
            } else if (pt instanceof PrefixParentNode) {
                J.ClassDecl innerClassDecl;
                String fieldName = pt.getName();
                String innerClassName = StringUtils.capitalize((String)fieldName);
                Optional<J.ClassDecl> maybeInnerClassDecl = cd.getBody().getStatements().stream().filter(it -> it instanceof J.ClassDecl).map(J.ClassDecl.class::cast).filter(it -> it.getSimpleName().equals(innerClassName)).findAny();
                if (maybeInnerClassDecl.isPresent()) {
                    innerClassDecl = maybeInnerClassDecl.get();
                } else {
                    innerClassDecl = this.treeBuilder.buildInnerClassDeclaration(cd, "public static class " + innerClassName + " {\n}\n", new JavaType[0]);
                    List withNewDecl = cd.getBody().getStatements();
                    withNewDecl.add(innerClassDecl);
                    cd = cd.withBody(cd.getBody().withStatements(withNewDecl));
                    this.andThen((RefactorVisitor)new AutoFormat(new J[]{innerClassDecl}));
                }
                assert (innerClassDecl.getType() != null);
                this.andThen((RefactorVisitor)new AddField.Scoped(cd, Collections.singletonList(new J.Modifier.Private(Tree.randomId(), Formatting.EMPTY)), innerClassDecl.getType().getFullyQualifiedName(), fieldName, null));
                this.andThen((RefactorVisitor)new GenerateGetter.Scoped(cd, fieldName));
                this.andThen((RefactorVisitor)new GenerateSetter.Scoped(cd, fieldName));
                ((PrefixParentNode)pt).children.values().forEach(subTree -> this.generateClassesFieldsGettersSetters(innerClassDecl, (PrefixTree)subTree));
            }
        }
    }
}

