/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.sql.SqlDetector;
import org.openrewrite.sql.table.DatabaseColumnsUsed;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class FindSql
extends Recipe {
    transient DatabaseColumnsUsed used = new DatabaseColumnsUsed(this);

    public String getDisplayName() {
        return "Find SQL in code and resource files";
    }

    public String getDescription() {
        return "Find SQL in code (e.g. in string literals) and in resources like those ending with `.sql`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.not((TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                return (PlainText)SearchResult.found((Tree)text);
            }
        }), new HasSourcePath("**/*.sql")}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){
            final SqlDetector detector = new SqlDetector();

            @Nullable
            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    this.stopAfterPreVisit();
                    tree = new PlainTextVisitor<ExecutionContext>(){

                        public PlainText visitText(PlainText text, ExecutionContext ctx) {
                            return (PlainText)this.find(ctx, this.getCursor(), text.getText());
                        }
                    }.visit(tree, (Object)ctx);
                    tree = new JavaIsoVisitor<ExecutionContext>(){

                        public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                            return literal.getValue() instanceof String ? (J.Literal)this.find(ctx, this.getCursor(), (String)literal.getValue()) : literal;
                        }
                    }.visit(tree, (Object)ctx);
                    tree = new YamlIsoVisitor<ExecutionContext>(){

                        public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                            return (Yaml.Scalar)this.find(ctx, this.getCursor(), scalar.getValue());
                        }
                    }.visit(tree, (Object)ctx);
                }
                return tree;
            }

            private <T extends Tree> T find(ExecutionContext ctx, Cursor cursor, String text) {
                return (T)cursor.getPathAsStream(v -> v instanceof SourceFile).findFirst().map(SourceFile.class::cast).map(sourceFile -> {
                    Tree t = (Tree)cursor.getValue();
                    for (DatabaseColumnsUsed.Row row : this.detector.rows((SourceFile)sourceFile, text)) {
                        FindSql.this.used.insertRow(ctx, row);
                        t = SearchResult.found((Tree)t);
                    }
                    return t;
                }).orElseGet(() -> ((Cursor)cursor).getValue());
            }
        });
    }
}

