/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.sql.SqlDetector;
import org.openrewrite.sql.table.DatabaseColumnsUsed;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class FindSql
extends Recipe {
    transient DatabaseColumnsUsed used = new DatabaseColumnsUsed(this);

    public String getDisplayName() {
        return "Find SQL in code and resource files";
    }

    public String getDescription() {
        return "Find SQL in code (e.g. in string literals) and in resources like those ending with `.sql`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.not((TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                return (PlainText)SearchResult.found((Tree)text);
            }
        }), new HasSourcePath("**/*.sql")}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){
            final SqlDetector detector = new SqlDetector();

            @Nullable
            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    this.stopAfterPreVisit();
                    tree = new PlainTextVisitor<ExecutionContext>(){

                        public PlainText visitText(PlainText text, ExecutionContext ctx) {
                            return (PlainText)this.find(ctx, 1, this.getCursor(), text.getText());
                        }
                    }.visit(tree, (Object)ctx);
                    tree = new JavaIsoVisitor<ExecutionContext>(){
                        int lineNumber = 1;

                        public Space visitSpace(Space space, Space.Location loc, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(space);
                            return space;
                        }

                        public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                            this.visitSpace(literal.getPrefix(), Space.Location.LITERAL_PREFIX, ctx);
                            if (literal.getValue() instanceof String) {
                                literal = (J.Literal)this.find(ctx, this.lineNumber, this.getCursor(), (String)literal.getValue());
                                assert (literal.getValue() != null);
                                this.lineNumber += FindSql.countLines(literal.getValue().toString());
                            }
                            return literal;
                        }
                    }.visit(tree, (Object)ctx);
                    tree = new YamlIsoVisitor<ExecutionContext>(){
                        int lineNumber = 1;

                        public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                            this.lineNumber += FindSql.countLines(scalar.getPrefix());
                            Yaml.Scalar s = (Yaml.Scalar)this.find(ctx, this.lineNumber, this.getCursor(), scalar.getValue());
                            this.lineNumber += FindSql.countLines(s.getValue());
                            return s;
                        }

                        public Yaml.Documents visitDocuments(Yaml.Documents documents, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(documents.getPrefix());
                            return super.visitDocuments(documents, (Object)executionContext);
                        }

                        public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(document.getPrefix());
                            return super.visitDocument(document, (Object)executionContext);
                        }

                        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(entry.getPrefix());
                            this.lineNumber += FindSql.countLines(entry.getBeforeMappingValueIndicator());
                            return super.visitMappingEntry(entry, (Object)executionContext);
                        }

                        public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(entry.getPrefix());
                            return super.visitSequenceEntry(entry, (Object)executionContext);
                        }

                        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(mapping.getPrefix());
                            this.lineNumber += FindSql.countLines(mapping.getOpeningBracePrefix());
                            Yaml.Mapping m = super.visitMapping(mapping, (Object)executionContext);
                            this.lineNumber += FindSql.countLines(m.getClosingBracePrefix());
                            return m;
                        }

                        public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(sequence.getPrefix());
                            this.lineNumber += FindSql.countLines(sequence.getOpeningBracketPrefix());
                            Yaml.Sequence s = super.visitSequence(sequence, (Object)executionContext);
                            this.lineNumber += FindSql.countLines(s.getOpeningBracketPrefix());
                            return s;
                        }

                        public Yaml visitAlias(Yaml.Alias alias, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(alias.getPrefix());
                            return super.visitAlias(alias, (Object)executionContext);
                        }

                        public Yaml visitAnchor(Yaml.Anchor anchor, ExecutionContext executionContext) {
                            this.lineNumber += FindSql.countLines(anchor.getPrefix());
                            return super.visitAnchor(anchor, (Object)executionContext);
                        }
                    }.visit(tree, (Object)ctx);
                }
                return tree;
            }

            private <T extends Tree> T find(ExecutionContext ctx, int lineNumber, Cursor cursor, String text) {
                return (T)cursor.getPathAsStream(SourceFile.class::isInstance).findFirst().map(SourceFile.class::cast).map(sourceFile -> {
                    Tree t = (Tree)cursor.getValue();
                    String commitHash = sourceFile.getMarkers().findFirst(GitProvenance.class).map(GitProvenance::getChange).orElse(null);
                    for (DatabaseColumnsUsed.Row row : this.detector.rows((SourceFile)sourceFile, commitHash, lineNumber, text)) {
                        FindSql.this.used.insertRow(ctx, row);
                        t = SearchResult.found((Tree)t);
                    }
                    return t;
                }).orElseGet(() -> ((Cursor)cursor).getValue());
            }
        });
    }

    private static int countLines(@Nullable String s) {
        if (s == null) {
            return 0;
        }
        return StringUtils.countOccurrences((String)s, (String)"\n");
    }

    private static int countLines(Space space) {
        int n = StringUtils.countOccurrences((String)space.getWhitespace(), (String)"\n");
        for (Comment comment : space.getComments()) {
            if (comment instanceof TextComment) {
                TextComment textComment = (TextComment)comment;
                n += StringUtils.countOccurrences((String)textComment.getText(), (String)"\n");
            } else if (comment instanceof Javadoc.DocComment) {
                Javadoc.DocComment docComment = (Javadoc.DocComment)comment;
                n += StringUtils.countOccurrences((String)docComment.toString(), (String)"\n");
            }
            n += StringUtils.countOccurrences((String)comment.getSuffix(), (String)"\n");
        }
        return n;
    }
}

