/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.core.FormatConfig;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.sql.Indenter;
import org.openrewrite.sql.SqlDetector;

class SqlTextBlockFormatVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final SqlDetector sqlDetector = new SqlDetector();
    private final FormatConfig config;
    private final SqlFormatter.Formatter sqlFormatter;

    SqlTextBlockFormatVisitor(String sqlDialect, String indent, Integer maxColumnLength, Boolean uppercase) {
        FormatConfig.FormatConfigBuilder builder = FormatConfig.builder();
        if (indent != null) {
            builder = builder.indent(indent);
        }
        if (uppercase != null) {
            builder = builder.uppercase(uppercase.booleanValue());
        }
        if (maxColumnLength != null) {
            builder = builder.maxColumnLength(maxColumnLength.intValue());
        }
        this.config = builder.build();
        this.sqlFormatter = SqlFormatter.of((String)sqlDialect);
    }

    public J.Literal visitLiteral(J.Literal lit, ExecutionContext ctx) {
        String formatted;
        String originalValue;
        J.Literal literal = super.visitLiteral(lit, (Object)ctx);
        if (this.isTextBlock(literal) && this.sqlDetector.isSql(originalValue = (String)literal.getValue()) && !originalValue.equals(formatted = this.sqlFormatter.format(originalValue, this.config))) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getStyle(TabsAndIndentsStyle.class);
            String indented = Indenter.indent(literal.getValueSource(), formatted, style);
            return literal.withValue((Object)formatted).withValueSource(String.format("\"\"\"%s\"\"\"", indented));
        }
        return literal;
    }

    private boolean isTextBlock(J.Literal l) {
        return TypeUtils.isString((JavaType)l.getType()) && l.getValueSource() != null && l.getValueSource().startsWith("\"\"\"");
    }
}

