/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql.search;

import java.util.concurrent.atomic.AtomicReference;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.sql.table.DatabaseFunctions;
import org.openrewrite.sql.table.DatabaseQueries;
import org.openrewrite.sql.trait.SqlQuery;

public final class FindFunction
extends Recipe {
    private final transient DatabaseQueries databaseQueries = new DatabaseQueries(this);
    private final transient DatabaseFunctions databaseFunctions = new DatabaseFunctions(this);
    @Option(displayName="Function name", description="The name of the function to find, case insensitive.", example="nvl")
    private final String functionName;

    public String getDisplayName() {
        return "Find SQL function";
    }

    public String getDescription() {
        return "Find SQL functions by name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree preVisit(Tree tree, final ExecutionContext ctx) {
                return (Tree)SqlQuery.viewOf(this.getCursor()).map(q -> {
                    AtomicReference<Boolean> found = new AtomicReference<Boolean>(false);
                    q.mapSql(new ExpressionDeParser((SqlQuery)q, found){
                        final /* synthetic */ SqlQuery val$q;
                        final /* synthetic */ AtomicReference val$found;
                        {
                            this.val$q = sqlQuery;
                            this.val$found = atomicReference;
                        }

                        public void visit(Function function) {
                            if (StringUtils.matchesGlob((String)function.getName(), (String)FindFunction.this.functionName)) {
                                FindFunction.this.databaseQueries.insertRow(ctx, new DatabaseQueries.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), this.val$q.getSql()));
                                FindFunction.this.databaseFunctions.insertRow(ctx, new DatabaseFunctions.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), function.getName().toLowerCase(), this.val$q.getSql()));
                                this.val$found.set(true);
                            }
                            super.visit(function);
                        }
                    });
                    return found.get() != false ? SearchResult.found((Tree)tree) : tree;
                }).orSuccess((Object)super.preVisit(tree, (Object)ctx));
            }
        };
    }

    public FindFunction(String functionName) {
        this.functionName = functionName;
    }

    public DatabaseQueries getDatabaseQueries() {
        return this.databaseQueries;
    }

    public DatabaseFunctions getDatabaseFunctions() {
        return this.databaseFunctions;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String toString() {
        return "FindFunction(databaseQueries=" + (Object)((Object)this.getDatabaseQueries()) + ", databaseFunctions=" + (Object)((Object)this.getDatabaseFunctions()) + ", functionName=" + this.getFunctionName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFunction)) {
            return false;
        }
        FindFunction other = (FindFunction)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        return !(this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        return result;
    }
}

