/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql.trait;

import fj.data.Validation;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.TraitFactory;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.sql.trait.SqlDetector;
import org.openrewrite.sql.trait.SqlQueryBase;
import org.openrewrite.text.PlainText;

public interface SqlQuery
extends Top {
    public static Validation<TraitErrors, SqlQuery> viewOf(Cursor cursor) {
        return Factory.F.viewOf(cursor);
    }

    public Tree mapSql(ExpressionDeParser var1);

    public String getSql();

    public Statement getQuery();

    public static enum Factory implements TraitFactory<SqlQuery>
    {
        F;


        public Validation<TraitErrors, SqlQuery> viewOf(Cursor cursor) {
            PlainText plainText;
            if (cursor.getValue() instanceof J.Literal) {
                J.Literal literal = (J.Literal)cursor.getValue();
                if (SqlDetector.probablySql(literal.getValue())) {
                    return SqlQueryBase.viewOf(cursor, literal.getValue().toString()).map(m -> m);
                }
            } else if (cursor.getValue() instanceof PlainText && SqlDetector.probablySql((plainText = (PlainText)cursor.getValue()).getText())) {
                return SqlQueryBase.viewOf(cursor, plainText.getText()).map(m -> m);
            }
            return TraitErrors.invalidTraitCreationType(SqlQuery.class, (Cursor)cursor, Expression.class, PlainText.class);
        }
    }
}

