/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql.trait;

import fj.data.Validation;
import java.util.UUID;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.java.tree.J;
import org.openrewrite.sql.internal.ChangeTrackingExpressionDeParser;
import org.openrewrite.sql.trait.SqlQuery;
import org.openrewrite.text.PlainText;

class SqlQueryBase
extends Top.Base
implements SqlQuery {
    private final Tree tree;
    private final String sql;
    private final Statement query;

    static Validation<TraitErrors, SqlQueryBase> viewOf(Cursor cursor, String sql) {
        try {
            return Validation.success((Object)new SqlQueryBase((Tree)cursor.getValue(), sql, CCJSqlParserUtil.parse((String)sql)));
        }
        catch (JSQLParserException e) {
            return TraitErrors.invalidTraitCreation(SqlQuery.class, (String)("Failed to parse SQL: " + e.getMessage()));
        }
    }

    @Override
    public Tree mapSql(ExpressionDeParser map) {
        try {
            StringBuilder sb = new StringBuilder();
            SelectDeParser selectDeParser = new SelectDeParser((ExpressionVisitor)map, sb);
            map.setSelectVisitor((SelectVisitor)selectDeParser);
            map.setBuffer(sb);
            StatementDeParser statementDeParser = new StatementDeParser(map, selectDeParser, sb);
            this.query.accept((StatementVisitor)statementDeParser);
            return this.updateSql(sb.toString(), map);
        }
        catch (Throwable t) {
            return this.tree;
        }
    }

    private Tree updateSql(String sql, ExpressionDeParser deparser) {
        if (deparser instanceof ChangeTrackingExpressionDeParser) {
            sql = ChangeTrackingExpressionDeParser.applyChange(this.sql, sql);
        }
        if (this.tree instanceof PlainText) {
            return ((PlainText)this.tree).withText(sql);
        }
        if (this.tree instanceof J.Literal) {
            J.Literal literal = (J.Literal)this.tree;
            return literal.withValue((Object)sql).withValueSource("\"" + sql + "\"");
        }
        return this.tree;
    }

    public UUID getId() {
        return this.tree.getId();
    }

    public SqlQueryBase(Tree tree, String sql, Statement query) {
        this.tree = tree;
        this.sql = sql;
        this.query = query;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public Statement getQuery() {
        return this.query;
    }
}

