/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import lombok.Generated;
import net.sf.jsqlparser.expression.Function;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.sql.internal.ChangeTrackingExpressionDeParser;
import org.openrewrite.sql.table.DatabaseFunctions;
import org.openrewrite.sql.table.DatabaseQueries;
import org.openrewrite.sql.trait.SqlQuery;

public final class ChangeFunctionName
extends Recipe {
    private final transient DatabaseQueries databaseQueries = new DatabaseQueries(this);
    private final transient DatabaseFunctions databaseFunctions = new DatabaseFunctions(this);
    @Option(displayName="Old function name", description="The name of the function to find, case insensitive.", example="NVL")
    private final String oldFunctionName;
    @Option(displayName="New function name", description="The new name to use. This will match the casing of the original method when a replacement is made.", example="COALESCE")
    private final String newFunctionName;

    public String getDisplayName() {
        return "Change a SQL function name";
    }

    public String getDescription() {
        return "When migrating between dialects, often one name can be substituted for another. For example, Oracle's NVL function can be replaced with Postgres COALESCE.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree preVisit(Tree tree, final ExecutionContext ctx) {
                return (Tree)SqlQuery.viewOf(this.getCursor()).map(q -> q.mapSql(new ChangeTrackingExpressionDeParser((SqlQuery)q){
                    final /* synthetic */ SqlQuery val$q;
                    {
                        this.val$q = sqlQuery;
                    }

                    public void visit(Function function) {
                        if (StringUtils.matchesGlob((String)function.getName(), (String)ChangeFunctionName.this.oldFunctionName)) {
                            ChangeFunctionName.this.databaseQueries.insertRow(ctx, new DatabaseQueries.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), this.val$q.getSql()));
                            ChangeFunctionName.this.databaseFunctions.insertRow(ctx, new DatabaseFunctions.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), function.getName().toLowerCase(), this.val$q.getSql()));
                            this.trackChange(() -> {
                                function.setName(ChangeFunctionName.this.newFunctionName);
                                super.visit(function);
                            });
                        } else {
                            super.visit(function);
                        }
                    }
                })).orSuccess((Object)super.preVisit(tree, (Object)ctx));
            }
        };
    }

    @Generated
    public ChangeFunctionName(String oldFunctionName, String newFunctionName) {
        this.oldFunctionName = oldFunctionName;
        this.newFunctionName = newFunctionName;
    }

    @Generated
    public DatabaseQueries getDatabaseQueries() {
        return this.databaseQueries;
    }

    @Generated
    public DatabaseFunctions getDatabaseFunctions() {
        return this.databaseFunctions;
    }

    @Generated
    public String getOldFunctionName() {
        return this.oldFunctionName;
    }

    @Generated
    public String getNewFunctionName() {
        return this.newFunctionName;
    }

    @Generated
    public String toString() {
        return "ChangeFunctionName(databaseQueries=" + (Object)((Object)this.getDatabaseQueries()) + ", databaseFunctions=" + (Object)((Object)this.getDatabaseFunctions()) + ", oldFunctionName=" + this.getOldFunctionName() + ", newFunctionName=" + this.getNewFunctionName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeFunctionName)) {
            return false;
        }
        ChangeFunctionName other = (ChangeFunctionName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldFunctionName = this.getOldFunctionName();
        String other$oldFunctionName = other.getOldFunctionName();
        if (this$oldFunctionName == null ? other$oldFunctionName != null : !this$oldFunctionName.equals(other$oldFunctionName)) {
            return false;
        }
        String this$newFunctionName = this.getNewFunctionName();
        String other$newFunctionName = other.getNewFunctionName();
        return !(this$newFunctionName == null ? other$newFunctionName != null : !this$newFunctionName.equals(other$newFunctionName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeFunctionName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldFunctionName = this.getOldFunctionName();
        result = result * 59 + ($oldFunctionName == null ? 43 : $oldFunctionName.hashCode());
        String $newFunctionName = this.getNewFunctionName();
        result = result * 59 + ($newFunctionName == null ? 43 : $newFunctionName.hashCode());
        return result;
    }
}

