/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.core.FormatConfig;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.sql.Indenter;
import org.openrewrite.sql.SqlDetector;

public final class FormatSql
extends Recipe {
    @Option(displayName="SQL dialect to be used to format SQL snippets.", description="Check out https://github.com/vertical-blank/sql-formatter#dialect for supported dialects.", valid={"sql", "mariadb", "mysql", "postgresql", "db2", "plsql", "n1ql", "redshift", "spark", "tsql"}, example="postgresql", required=false)
    @Nullable
    private final String sqlDialect;
    @Option(displayName="Characters used for indentation.", description="Defaults to two spaces.", example="    ", required=false)
    @Nullable
    private final String indent;
    @Option(displayName="Maximum length to treat inline block as one line.", description="Defaults to 50.", example="100", required=false)
    @Nullable
    private final Integer maxColumnLength;
    @Option(displayName="Converts keywords to uppercase.", description="Defaults to false (not safe to use when SQL dialect has case-sensitive identifiers).", example="true", required=false)
    @Nullable
    private final Boolean uppercase;

    public FormatSql() {
        this(Dialect.StandardSql.name());
    }

    public FormatSql(String sqlDialect) {
        this(sqlDialect, null, null, null);
    }

    public FormatSql(@Nullable String sqlDialect, @Nullable String indent, @Nullable Integer maxColumnLength, @Nullable Boolean uppercase) {
        this.sqlDialect = sqlDialect;
        this.indent = indent;
        this.maxColumnLength = maxColumnLength;
        this.uppercase = uppercase;
    }

    public String getDisplayName() {
        return "Format SQL in string text blocks";
    }

    public String getDescription() {
        return "Checks whether a text block may contain SQL, and if so, formats the text accordingly.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        FormatConfig.FormatConfigBuilder builder = FormatConfig.builder();
        if (this.indent != null) {
            builder = builder.indent(this.indent);
        }
        if (this.uppercase != null) {
            builder = builder.uppercase(this.uppercase.booleanValue());
        }
        if (this.maxColumnLength != null) {
            builder = builder.maxColumnLength(this.maxColumnLength.intValue());
        }
        final FormatConfig config = builder.build();
        final SqlFormatter.Formatter sqlFormatter = SqlFormatter.of((String)this.sqlDialect);
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(15), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final SqlDetector sqlDetector = new SqlDetector();

            public J.Literal visitLiteral(J.Literal lit, ExecutionContext ctx) {
                String formatted;
                String originalValue;
                J.Literal literal = super.visitLiteral(lit, (Object)ctx);
                if (this.isTextBlock(literal) && this.sqlDetector.isSql(originalValue = (String)literal.getValue()) && !originalValue.equals(formatted = sqlFormatter.format(originalValue, config))) {
                    TabsAndIndentsStyle style = (TabsAndIndentsStyle)((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getStyle(TabsAndIndentsStyle.class);
                    String indented = Indenter.indent(literal.getValueSource(), formatted, style);
                    return literal.withValue((Object)formatted).withValueSource(String.format("\"\"\"%s\"\"\"", indented));
                }
                return literal;
            }

            private boolean isTextBlock(J.Literal l) {
                return TypeUtils.isString((JavaType)l.getType()) && l.getValueSource() != null && l.getValueSource().startsWith("\"\"\"");
            }
        });
    }

    @Generated
    public String getSqlDialect() {
        return this.sqlDialect;
    }

    @Generated
    public String getIndent() {
        return this.indent;
    }

    @Generated
    public Integer getMaxColumnLength() {
        return this.maxColumnLength;
    }

    @Generated
    public Boolean getUppercase() {
        return this.uppercase;
    }

    @Generated
    public String toString() {
        return "FormatSql(sqlDialect=" + this.getSqlDialect() + ", indent=" + this.getIndent() + ", maxColumnLength=" + this.getMaxColumnLength() + ", uppercase=" + this.getUppercase() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormatSql)) {
            return false;
        }
        FormatSql other = (FormatSql)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$maxColumnLength = this.getMaxColumnLength();
        Integer other$maxColumnLength = other.getMaxColumnLength();
        if (this$maxColumnLength == null ? other$maxColumnLength != null : !((Object)this$maxColumnLength).equals(other$maxColumnLength)) {
            return false;
        }
        Boolean this$uppercase = this.getUppercase();
        Boolean other$uppercase = other.getUppercase();
        if (this$uppercase == null ? other$uppercase != null : !((Object)this$uppercase).equals(other$uppercase)) {
            return false;
        }
        String this$sqlDialect = this.getSqlDialect();
        String other$sqlDialect = other.getSqlDialect();
        if (this$sqlDialect == null ? other$sqlDialect != null : !this$sqlDialect.equals(other$sqlDialect)) {
            return false;
        }
        String this$indent = this.getIndent();
        String other$indent = other.getIndent();
        return !(this$indent == null ? other$indent != null : !this$indent.equals(other$indent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FormatSql;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxColumnLength = this.getMaxColumnLength();
        result = result * 59 + ($maxColumnLength == null ? 43 : ((Object)$maxColumnLength).hashCode());
        Boolean $uppercase = this.getUppercase();
        result = result * 59 + ($uppercase == null ? 43 : ((Object)$uppercase).hashCode());
        String $sqlDialect = this.getSqlDialect();
        result = result * 59 + ($sqlDialect == null ? 43 : $sqlDialect.hashCode());
        String $indent = this.getIndent();
        result = result * 59 + ($indent == null ? 43 : $indent.hashCode());
        return result;
    }
}

