/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql.trait;

import java.util.regex.Pattern;
import lombok.Generated;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.trait.Traits;
import org.openrewrite.java.tree.J;
import org.openrewrite.sql.internal.ChangeTrackingExpressionDeParser;
import org.openrewrite.text.PlainText;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;

public final class SqlQuery
implements Trait<Tree> {
    private final Cursor cursor;

    public String getString() {
        Object value = this.cursor.getValue();
        if (value instanceof J.Literal) {
            return Traits.literal().get(this.cursor).map(Literal::getString).orElseThrow(() -> new IllegalStateException("Should have only matched on string literals"));
        }
        if (value instanceof PlainText) {
            return ((PlainText)value).getText();
        }
        throw new UnsupportedOperationException("Implement SQL extraction from tree type " + value.getClass().getName());
    }

    public Statement getStatement() {
        try {
            return CCJSqlParserUtil.parse((String)this.getString());
        }
        catch (JSQLParserException e) {
            throw new IllegalStateException("Unexpected SQL parsing error since parsing was validated prior to the creation of the trait.");
        }
    }

    public Tree visitSql(ExpressionDeParser map) {
        try {
            StringBuilder sb = new StringBuilder();
            SelectDeParser selectDeParser = new SelectDeParser((ExpressionVisitor)map, sb);
            map.setSelectVisitor((SelectVisitor)selectDeParser);
            map.setBuffer(sb);
            StatementDeParser statementDeParser = new StatementDeParser(map, selectDeParser, sb);
            this.getStatement().accept((StatementVisitor)statementDeParser);
            return this.updateSql(sb.toString(), map);
        }
        catch (Throwable t) {
            return this.getTree();
        }
    }

    private Tree updateSql(String sql, ExpressionDeParser deparser) {
        Tree tree;
        if (deparser instanceof ChangeTrackingExpressionDeParser) {
            sql = ChangeTrackingExpressionDeParser.applyChange(this.getString(), sql);
        }
        if ((tree = this.getTree()) instanceof PlainText) {
            return ((PlainText)tree).withText(sql);
        }
        if (tree instanceof J.Literal) {
            J.Literal literal = (J.Literal)tree;
            return literal.withValue((Object)sql).withValueSource("\"" + sql + "\"");
        }
        return tree;
    }

    @Generated
    public SqlQuery(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlQuery)) {
            return false;
        }
        SqlQuery other = (SqlQuery)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SqlQuery(cursor=" + this.getCursor() + ")";
    }

    public static class Matcher
    extends SimpleTraitMatcher<SqlQuery> {
        private static final Pattern SIMPLE_SQL_HEURISTIC = Pattern.compile("SELECT|UPDATE|DELETE|INSERT", 2);

        @Nullable
        protected SqlQuery test(Cursor cursor) {
            PlainText plainText;
            String sql = null;
            Object value = cursor.getValue();
            if (value instanceof J.Literal) {
                J.Literal literal = (J.Literal)value;
                if (Matcher.probablySql(literal.getValue())) {
                    sql = literal.getValue().toString();
                }
            } else if (value instanceof PlainText && Matcher.probablySql((plainText = (PlainText)value).getText())) {
                sql = plainText.getText();
            }
            if (sql != null) {
                try {
                    CCJSqlParserUtil.parse(sql);
                    return new SqlQuery(cursor);
                }
                catch (JSQLParserException jSQLParserException) {
                    // empty catch block
                }
            }
            return null;
        }

        static boolean probablySql(@Nullable Object maybeSql) {
            return maybeSql != null && SIMPLE_SQL_HEURISTIC.matcher(maybeSql.toString()).find();
        }
    }
}

