/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import java.util.Optional;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;

class Indenter {
    Indenter() {
    }

    public static String indent(String valueSource, String formatted, @Nullable TabsAndIndentsStyle style) {
        TabsAndIndentsStyle tabsAndIndentsStyle = Optional.ofNullable(style).orElse(IntelliJ.tabsAndIndents());
        boolean useTab = tabsAndIndentsStyle.getUseTabCharacter();
        int tabSize = tabsAndIndentsStyle.getTabSize();
        String indentation = Indenter.getIndents(valueSource, useTab, tabSize);
        String indented = formatted.replace(" \n", "\\s\n");
        indented = indented.replace("\n", "\n" + indentation);
        indented = "\n" + indentation + indented;
        boolean isEndsWithNewLine = valueSource.endsWith("\n");
        if (!isEndsWithNewLine) {
            indented = indented + "\\\n" + indentation;
        }
        return indented;
    }

    private static String getIndents(String concatenation, boolean useTabCharacter, int tabSize) {
        int[] tabAndSpaceCounts = Indenter.shortestPrefixAfterNewline(concatenation, tabSize);
        int tabCount = tabAndSpaceCounts[0];
        int spaceCount = tabAndSpaceCounts[1];
        if (useTabCharacter) {
            return StringUtils.repeat((String)"\t", (int)tabCount) + StringUtils.repeat((String)" ", (int)spaceCount);
        }
        return StringUtils.repeat((String)" ", (int)(tabCount * tabSize + spaceCount));
    }

    private static int[] shortestPrefixAfterNewline(String concatenation, int tabSize) {
        int shortest = Integer.MAX_VALUE;
        int[] shortestPair = new int[]{0, 0};
        int tabCount = 0;
        int spaceCount = 0;
        boolean afterNewline = false;
        for (int i = 0; i < concatenation.length(); ++i) {
            char c = concatenation.charAt(i);
            if (c != ' ' && c != '\t' && afterNewline) {
                if (spaceCount + tabCount * tabSize < shortest) {
                    shortest = spaceCount + tabCount;
                    shortestPair[0] = tabCount;
                    shortestPair[1] = spaceCount;
                }
                afterNewline = false;
            }
            if (c == '\n') {
                afterNewline = true;
                spaceCount = 0;
                tabCount = 0;
                continue;
            }
            if (c == ' ') {
                if (!afterNewline) continue;
                ++spaceCount;
                continue;
            }
            if (c == '\t') {
                if (!afterNewline) continue;
                ++tabCount;
                continue;
            }
            afterNewline = false;
            spaceCount = 0;
            tabCount = 0;
        }
        if (spaceCount + tabCount > 0 && spaceCount + tabCount < shortest) {
            shortestPair[0] = tabCount;
            shortestPair[1] = spaceCount;
        }
        return shortestPair;
    }
}

