/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import lombok.Generated;
import net.sf.jsqlparser.expression.Function;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.sql.internal.ChangeTrackingExpressionDeParser;
import org.openrewrite.sql.table.DatabaseFunctions;
import org.openrewrite.sql.table.DatabaseQueries;
import org.openrewrite.sql.trait.SqlQuery;

public final class ChangeFunctionName
extends Recipe {
    private final transient DatabaseQueries databaseQueries = new DatabaseQueries(this);
    private final transient DatabaseFunctions databaseFunctions = new DatabaseFunctions(this);
    @Option(displayName="Old function name", description="The name of the function to find, case insensitive.", example="NVL")
    private final String oldFunctionName;
    @Option(displayName="New function name", description="The new name to use. This will match the casing of the original method when a replacement is made.", example="COALESCE")
    private final String newFunctionName;

    public String getDisplayName() {
        return "Change a SQL function name";
    }

    public String getDescription() {
        return "When migrating between dialects, often one name can be substituted for another. For example, Oracle's `NVL` function can be replaced with Postgres `COALESCE`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SqlQuery.Matcher().asVisitor((sql, ctx) -> sql.visitSql(new ChangeTrackingExpressionDeParser((ExecutionContext)ctx, (SqlQuery)sql){
            final /* synthetic */ ExecutionContext val$ctx;
            final /* synthetic */ SqlQuery val$sql;
            {
                this.val$ctx = executionContext;
                this.val$sql = sqlQuery;
            }

            public StringBuilder visit(Function function, Object o) {
                if (StringUtils.matchesGlob((String)function.getName(), (String)ChangeFunctionName.this.oldFunctionName)) {
                    ChangeFunctionName.this.databaseQueries.insertRow(this.val$ctx, new DatabaseQueries.Row(((SourceFile)this.val$sql.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), this.val$sql.getString()));
                    ChangeFunctionName.this.databaseFunctions.insertRow(this.val$ctx, new DatabaseFunctions.Row(((SourceFile)this.val$sql.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), function.getName().toLowerCase(), this.val$sql.getString()));
                    this.trackChange(() -> function.setName(ChangeFunctionName.this.newFunctionName));
                }
                return super.visit(function, o);
            }
        }));
    }

    @Generated
    public ChangeFunctionName(String oldFunctionName, String newFunctionName) {
        this.oldFunctionName = oldFunctionName;
        this.newFunctionName = newFunctionName;
    }

    @Generated
    public DatabaseQueries getDatabaseQueries() {
        return this.databaseQueries;
    }

    @Generated
    public DatabaseFunctions getDatabaseFunctions() {
        return this.databaseFunctions;
    }

    @Generated
    public String getOldFunctionName() {
        return this.oldFunctionName;
    }

    @Generated
    public String getNewFunctionName() {
        return this.newFunctionName;
    }

    @Generated
    public String toString() {
        return "ChangeFunctionName(databaseQueries=" + (Object)((Object)this.getDatabaseQueries()) + ", databaseFunctions=" + (Object)((Object)this.getDatabaseFunctions()) + ", oldFunctionName=" + this.getOldFunctionName() + ", newFunctionName=" + this.getNewFunctionName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeFunctionName)) {
            return false;
        }
        ChangeFunctionName other = (ChangeFunctionName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldFunctionName = this.getOldFunctionName();
        String other$oldFunctionName = other.getOldFunctionName();
        if (this$oldFunctionName == null ? other$oldFunctionName != null : !this$oldFunctionName.equals(other$oldFunctionName)) {
            return false;
        }
        String this$newFunctionName = this.getNewFunctionName();
        String other$newFunctionName = other.getNewFunctionName();
        return !(this$newFunctionName == null ? other$newFunctionName != null : !this$newFunctionName.equals(other$newFunctionName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeFunctionName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldFunctionName = this.getOldFunctionName();
        result = result * 59 + ($oldFunctionName == null ? 43 : $oldFunctionName.hashCode());
        String $newFunctionName = this.getNewFunctionName();
        result = result * 59 + ($newFunctionName == null ? 43 : $newFunctionName.hashCode());
        return result;
    }
}

