/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;

public class ObjectFinalizeCallsSuper
extends Recipe {
    private static final MethodMatcher FINALIZE_METHOD_MATCHER = new MethodMatcher("java.lang.Object finalize()", true);

    public String getDisplayName() {
        return "`finalize()` calls super";
    }

    public String getDescription() {
        return "Overrides of `Object#finalize()` should call super.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1114");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new DeclaresMethod(FINALIZE_METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)executionContext);
                if (FINALIZE_METHOD_MATCHER.matches(md.getMethodType()) && !this.hasSuperFinalizeMethodInvocation(md)) {
                    md = (J.MethodDeclaration)JavaTemplate.builder((String)"super.finalize()").contextSensitive().build().apply(this.updateCursor((Tree)md), md.getBody().getCoordinates().lastStatement(), new Object[0]);
                }
                return md;
            }

            private boolean hasSuperFinalizeMethodInvocation(J.MethodDeclaration md) {
                AtomicBoolean hasSuperFinalize = new AtomicBoolean(Boolean.FALSE);
                new FindSuperFinalizeVisitor().visit((Tree)md, hasSuperFinalize);
                return hasSuperFinalize.get();
            }
        });
    }

    private static class FindSuperFinalizeVisitor
    extends JavaIsoVisitor<AtomicBoolean> {
        private FindSuperFinalizeVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean exists) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)exists);
            if (FINALIZE_METHOD_MATCHER.matches(mi)) {
                exists.set(Boolean.TRUE);
            }
            return mi;
        }
    }
}

