/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;

public final class RemoveUnusedLocalVariables
extends Recipe {
    @Option(displayName="Ignore matching variable names", description="An array of variable identifier names for local variables to ignore, even if the local variable is unused.", required=false, example="[unused, notUsed, IGNORE_ME]")
    @Nullable
    @Incubating(since="7.17.2")
    private final String[] ignoreVariablesNamed;

    public String getDisplayName() {
        return "Remove unused local variables";
    }

    public String getDescription() {
        return "If a local variable is declared but not used, it is dead code and should be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1481");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        HashSet<String> ignoreVariableNames;
        final MethodMatcher SAFE_GETTER_METHODS = new MethodMatcher("java.io.File get*(..)");
        if (this.ignoreVariablesNamed == null) {
            ignoreVariableNames = null;
        } else {
            ignoreVariableNames = new HashSet<String>(this.ignoreVariablesNamed.length);
            ignoreVariableNames.addAll(Arrays.asList(this.ignoreVariablesNamed));
        }
        return new JavaIsoVisitor<ExecutionContext>(){

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.ForEachLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Resource || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda || is instanceof JavaSourceFile);
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                if (ignoreVariableNames != null && ignoreVariableNames.contains(variable.getSimpleName())) {
                    return variable;
                }
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                J parent = (J)parentScope.getValue();
                if (parentScope.getParent() == null || parentScope.getParent().getValue() instanceof J.ClassDeclaration || parentScope.getValue() instanceof J.ClassDeclaration || parentScope.getParent().getValue() instanceof J.NewClass || parent instanceof J.MethodDeclaration || parent instanceof J.ForLoop.Control || parent instanceof J.ForEachLoop.Control || parent instanceof J.Try.Resource || parent instanceof J.Try.Catch || parent instanceof J.MultiCatch || parent instanceof J.Lambda || this.initializerMightSideEffect(variable)) {
                    return variable;
                }
                List readReferences = References.findRhsReferences((J)parentScope.getValue(), variable.getName());
                if (readReferences.isEmpty()) {
                    List assignmentReferences = References.findLhsReferences((J)parentScope.getValue(), variable.getName());
                    for (Statement ref : assignmentReferences) {
                        if (ref instanceof J.Assignment) {
                            this.doAfterVisit((TreeVisitor)new PruneAssignmentExpression((J.Assignment)ref));
                        }
                        this.doAfterVisit((TreeVisitor)new DeleteStatement(ref));
                    }
                    return null;
                }
                return super.visitVariable(variable, (Object)ctx);
            }

            public Statement visitStatement(Statement statement, ExecutionContext executionContext) {
                List comments = (List)this.getCursor().pollNearestMessage("COMMENTS_KEY");
                if (comments != null) {
                    statement = (Statement)statement.withComments(ListUtils.concatAll((List)statement.getComments(), (List)comments));
                }
                return super.visitStatement(statement, (Object)executionContext);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (!multiVariable.getAllAnnotations().isEmpty()) {
                    return multiVariable;
                }
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (mv.getVariables().isEmpty()) {
                    if (!mv.getPrefix().getComments().isEmpty()) {
                        this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration).putMessage("COMMENTS_KEY", (Object)mv.getPrefix().getComments());
                    }
                    this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)mv));
                }
                return mv;
            }

            private boolean initializerMightSideEffect(J.VariableDeclarations.NamedVariable variable) {
                if (variable.getInitializer() == null) {
                    return false;
                }
                AtomicBoolean mightSideEffect = new AtomicBoolean(false);
                new JavaIsoVisitor<AtomicBoolean>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, AtomicBoolean result) {
                        if (SAFE_GETTER_METHODS.matches(methodInvocation)) {
                            return methodInvocation;
                        }
                        result.set(true);
                        return methodInvocation;
                    }

                    public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean result) {
                        result.set(true);
                        return assignment;
                    }
                }.visit((Tree)variable.getInitializer(), (Object)mightSideEffect);
                return mightSideEffect.get();
            }
        };
    }

    public RemoveUnusedLocalVariables(String[] ignoreVariablesNamed) {
        this.ignoreVariablesNamed = ignoreVariablesNamed;
    }

    public String[] getIgnoreVariablesNamed() {
        return this.ignoreVariablesNamed;
    }

    public String toString() {
        return "RemoveUnusedLocalVariables(ignoreVariablesNamed=" + Arrays.deepToString(this.getIgnoreVariablesNamed()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedLocalVariables)) {
            return false;
        }
        RemoveUnusedLocalVariables other = (RemoveUnusedLocalVariables)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getIgnoreVariablesNamed(), other.getIgnoreVariablesNamed());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveUnusedLocalVariables;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getIgnoreVariablesNamed());
        return result;
    }

    private static class References {
        private References() {
        }

        private static boolean isIncrementKind(Cursor tree) {
            return tree.getValue() instanceof J.Unary && ((J.Unary)tree.getValue()).getOperator().isModifying();
        }

        @Nullable
        private static Cursor dropParentWhile(Predicate<Object> valuePredicate, Cursor cursor) {
            while (cursor != null && valuePredicate.test(cursor.getValue())) {
                cursor = cursor.getParent();
            }
            return cursor;
        }

        @Nullable
        private static Cursor dropParentUntil(Predicate<Object> valuePredicate, Cursor cursor) {
            while (cursor != null && !valuePredicate.test(cursor.getValue())) {
                cursor = cursor.getParent();
            }
            return cursor;
        }

        private static boolean isRhsValue(Cursor tree) {
            J.AssignmentOperation assignmentOperation;
            if (!(tree.getValue() instanceof J.Identifier)) {
                return false;
            }
            Cursor parent = References.dropParentWhile(J.Parentheses.class::isInstance, tree.getParent());
            assert (parent != null);
            if (parent.getValue() instanceof J.Assignment) {
                if (References.dropParentUntil(J.ControlParentheses.class::isInstance, parent) != null) {
                    return true;
                }
                J.Assignment assignment = (J.Assignment)parent.getValue();
                return assignment.getVariable() != tree.getValue();
            }
            if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)parent.getValue();
                return namedVariable.getName() != tree.getValue();
            }
            if (parent.getValue() instanceof J.AssignmentOperation && (assignmentOperation = (J.AssignmentOperation)parent.getValue()).getVariable() == tree.getValue()) {
                J grandParent = (J)parent.getParentTreeCursor().getValue();
                return grandParent instanceof Expression || grandParent instanceof J.Return;
            }
            return !References.isIncrementKind(parent) || !(parent.getParentTreeCursor().getValue() instanceof J.Block);
        }

        private static List<J> findRhsReferences(J j, final J.Identifier target) {
            ArrayList<J> refs = new ArrayList<J>();
            new JavaIsoVisitor<List<J>>(){

                public J.Identifier visitIdentifier(J.Identifier identifier, List<J> ctx) {
                    if (identifier.getSimpleName().equals(target.getSimpleName()) && References.isRhsValue(this.getCursor())) {
                        ctx.add((J)identifier);
                    }
                    return super.visitIdentifier(identifier, ctx);
                }
            }.visit((Tree)j, refs);
            return refs;
        }

        private static List<Statement> findLhsReferences(J j, final J.Identifier target) {
            JavaIsoVisitor<List<Statement>> visitor = new JavaIsoVisitor<List<Statement>>(){

                public J.Assignment visitAssignment(J.Assignment assignment, List<Statement> ctx) {
                    J.Identifier i;
                    if (assignment.getVariable() instanceof J.Identifier && (i = (J.Identifier)assignment.getVariable()).getSimpleName().equals(target.getSimpleName())) {
                        ctx.add((Statement)assignment);
                    }
                    return super.visitAssignment(assignment, ctx);
                }

                public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, List<Statement> ctx) {
                    J.Identifier i;
                    if (assignOp.getVariable() instanceof J.Identifier && (i = (J.Identifier)assignOp.getVariable()).getSimpleName().equals(target.getSimpleName())) {
                        ctx.add((Statement)assignOp);
                    }
                    return super.visitAssignmentOperation(assignOp, ctx);
                }

                public J.Unary visitUnary(J.Unary unary, List<Statement> ctx) {
                    J.Identifier i;
                    if (unary.getExpression() instanceof J.Identifier && (i = (J.Identifier)unary.getExpression()).getSimpleName().equals(target.getSimpleName())) {
                        ctx.add((Statement)unary);
                    }
                    return super.visitUnary(unary, ctx);
                }
            };
            ArrayList<Statement> refs = new ArrayList<Statement>();
            visitor.visit((Tree)j, refs);
            return refs;
        }
    }

    private static final class AssignmentToLiteral
    extends JavaVisitor<ExecutionContext> {
        private final J.Assignment assignment;

        public J visitAssignment(J.Assignment a, ExecutionContext executionContext) {
            if (this.assignment.isScope((Tree)a)) {
                return a.getAssignment().withPrefix(a.getPrefix());
            }
            return a;
        }

        public AssignmentToLiteral(J.Assignment assignment) {
            this.assignment = assignment;
        }

        public J.Assignment getAssignment() {
            return this.assignment;
        }

        public String toString() {
            return "RemoveUnusedLocalVariables.AssignmentToLiteral(assignment=" + this.getAssignment() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentToLiteral)) {
                return false;
            }
            AssignmentToLiteral other = (AssignmentToLiteral)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            J.Assignment this$assignment = this.getAssignment();
            J.Assignment other$assignment = other.getAssignment();
            return !(this$assignment == null ? other$assignment != null : !this$assignment.equals(other$assignment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssignmentToLiteral;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            J.Assignment $assignment = this.getAssignment();
            result = result * 59 + ($assignment == null ? 43 : $assignment.hashCode());
            return result;
        }
    }

    private static final class PruneAssignmentExpression
    extends JavaIsoVisitor<ExecutionContext> {
        private final J.Assignment assignment;

        public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> c, ExecutionContext executionContext) {
            c = (J.ControlParentheses)new AssignmentToLiteral(this.assignment).visitNonNull((Tree)c, executionContext, this.getCursor().getParentOrThrow());
            return c;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext executionContext) {
            AssignmentToLiteral atl = new AssignmentToLiteral(this.assignment);
            m = m.withArguments(ListUtils.map((List)m.getArguments(), it -> (Expression)atl.visitNonNull((Tree)it, executionContext, this.getCursor().getParentOrThrow())));
            return m;
        }

        public PruneAssignmentExpression(J.Assignment assignment) {
            this.assignment = assignment;
        }

        public J.Assignment getAssignment() {
            return this.assignment;
        }

        public String toString() {
            return "RemoveUnusedLocalVariables.PruneAssignmentExpression(assignment=" + this.getAssignment() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PruneAssignmentExpression)) {
                return false;
            }
            PruneAssignmentExpression other = (PruneAssignmentExpression)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            J.Assignment this$assignment = this.getAssignment();
            J.Assignment other$assignment = other.getAssignment();
            return !(this$assignment == null ? other$assignment != null : !this$assignment.equals(other$assignment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PruneAssignmentExpression;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            J.Assignment $assignment = this.getAssignment();
            result = result * 59 + ($assignment == null ? 43 : $assignment.hashCode());
            return result;
        }
    }
}

