/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class ExplicitLambdaArgumentTypes
extends Recipe {
    public String getDisplayName() {
        return "Use explicit types on lambda arguments";
    }

    public String getDescription() {
        return "Adds explicit types on lambda arguments, which are otherwise optional. This can make the code clearer and easier to read. This does not add explicit types on arguments when the lambda has one or two parameters and does not have a block body, as things are considered more readable in those cases. For example, `stream.map((a, b) -> a.length);` will not have explicit types added.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2211");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ExplicitLambdaArgumentTypesVisitor();
    }

    private static int countDimensions(JavaType type) {
        if (!(type instanceof JavaType.Array)) {
            return 0;
        }
        int count = 0;
        while (type instanceof JavaType.Array) {
            type = ((JavaType.Array)type).getElemType();
            ++count;
        }
        return count;
    }

    private static class ExplicitLambdaArgumentTypesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ExplicitLambdaArgumentTypesVisitor() {
        }

        public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            J.Lambda l = super.visitLambda(lambda, (Object)ctx);
            if (l.getParameters().getParameters().size() <= 2 && !(l.getBody() instanceof J.Block)) {
                return l;
            }
            J.Lambda after = l.withParameters(l.getParameters().withParameters(ListUtils.map((List)l.getParameters().getParameters(), parameter -> {
                if (parameter instanceof J.VariableDeclarations) {
                    return this.maybeAddTypeExpression((J.VariableDeclarations)parameter);
                }
                return parameter;
            })));
            if (after != l) {
                after = after.withParameters(after.getParameters().withParenthesized(true));
            }
            return after;
        }

        private J.VariableDeclarations maybeAddTypeExpression(J.VariableDeclarations multiVariable) {
            J.VariableDeclarations.NamedVariable nv;
            TypeTree typeExpression;
            if (multiVariable.getTypeExpression() == null && (typeExpression = this.buildTypeTree((nv = (J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0)).getType(), Space.EMPTY)) != null) {
                if (typeExpression instanceof J.Wildcard) {
                    J.Wildcard wildcard = (J.Wildcard)typeExpression;
                    if (wildcard.getBoundedType() == null) {
                        return multiVariable;
                    }
                    typeExpression = this.buildTypeTree(wildcard.getBoundedType().getType(), Space.EMPTY);
                }
                multiVariable = multiVariable.withTypeExpression(typeExpression);
                int arrayDimensions = ExplicitLambdaArgumentTypes.countDimensions(nv.getType());
                if (arrayDimensions > 0) {
                    ArrayList<JLeftPadded> dimensions = new ArrayList<JLeftPadded>();
                    for (int index2 = 0; index2 < arrayDimensions; ++index2) {
                        dimensions.add(new JLeftPadded(Space.EMPTY, (Object)Space.EMPTY, Markers.EMPTY));
                    }
                    multiVariable = multiVariable.withDimensionsBeforeName(dimensions);
                }
                multiVariable = multiVariable.withVariables(ListUtils.map((List)multiVariable.getVariables(), (index, variable) -> {
                    if (index == 0) {
                        return variable.withPrefix(variable.getPrefix().withWhitespace(" "));
                    }
                    return variable;
                }));
            }
            return multiVariable;
        }

        @Nullable
        private TypeTree buildTypeTree(@Nullable JavaType type, Space space) {
            if (type == null || type instanceof JavaType.Unknown) {
                return null;
            }
            if (type instanceof JavaType.Primitive) {
                return new J.Primitive(Tree.randomId(), space, Markers.EMPTY, (JavaType.Primitive)type);
            }
            if (type instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified fq = (JavaType.FullyQualified)type;
                J.Identifier identifier = new J.Identifier(Tree.randomId(), space, Markers.EMPTY, fq.getClassName(), type, null);
                if (!fq.getTypeParameters().isEmpty()) {
                    JContainer<Expression> typeParameters = this.buildTypeParameters(fq.getTypeParameters());
                    if (typeParameters == null) {
                        return null;
                    }
                    return new J.ParameterizedType(Tree.randomId(), space, Markers.EMPTY, (NameTree)identifier, typeParameters, (JavaType)new JavaType.Parameterized(null, fq, fq.getTypeParameters()));
                }
                this.maybeAddImport(fq);
                return identifier;
            }
            if (type instanceof JavaType.Array) {
                return this.buildTypeTree(((JavaType.Array)type).getElemType(), space);
            }
            if (type instanceof JavaType.Variable) {
                return this.buildTypeTree(((JavaType.Variable)type).getType(), space);
            }
            if (type instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericType = (JavaType.GenericTypeVariable)type;
                if (!genericType.getName().equals("?")) {
                    return new J.Identifier(Tree.randomId(), space, Markers.EMPTY, genericType.getName(), type, null);
                }
                JLeftPadded bound = null;
                TypeTree boundedType = null;
                if (genericType.getVariance() == JavaType.GenericTypeVariable.Variance.COVARIANT) {
                    bound = new JLeftPadded(Space.format((String)" "), (Object)J.Wildcard.Bound.Extends, Markers.EMPTY);
                } else if (genericType.getVariance() == JavaType.GenericTypeVariable.Variance.CONTRAVARIANT) {
                    bound = new JLeftPadded(Space.format((String)" "), (Object)J.Wildcard.Bound.Super, Markers.EMPTY);
                }
                if (!genericType.getBounds().isEmpty() && (boundedType = this.buildTypeTree((JavaType)genericType.getBounds().get(0), Space.format((String)" "))) == null) {
                    return null;
                }
                return new J.Wildcard(Tree.randomId(), space, Markers.EMPTY, bound, boundedType);
            }
            return null;
        }

        @Nullable
        private JContainer<Expression> buildTypeParameters(List<JavaType> typeParameters) {
            ArrayList<JRightPadded> typeExpressions = new ArrayList<JRightPadded>();
            for (JavaType type : typeParameters) {
                Expression typeParameterExpression = (Expression)this.buildTypeTree(type, Space.EMPTY);
                if (typeParameterExpression == null) {
                    return null;
                }
                typeExpressions.add(new JRightPadded((Object)typeParameterExpression, Space.EMPTY, Markers.EMPTY));
            }
            return JContainer.build((Space)Space.EMPTY, typeExpressions, (Markers)Markers.EMPTY);
        }
    }
}

