/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ReferentialEqualityToObjectEquals
extends Recipe {
    public String getDisplayName() {
        return "Replace referential equality operators with Object equals method invocations when the operands both override `Object.equals(Object obj)`";
    }

    public String getDescription() {
        return "Using `==` or `!=` compares object references, not the equality of two objects. This modifies code where both sides of a binary operation (`==` or `!=`) override `Object.equals(Object obj)` except when the comparison is within an overridden `Object.equals(Object obj)` method declaration itself. The resulting transformation must be carefully reviewed since any modifications change the program's semantics.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1698");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ReferentialEqualityToObjectEqualityVisitor();
    }

    private static class ReferentialEqualityToObjectEqualityVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final JavaType TYPE_OBJECT = JavaType.buildType((String)"java.lang.Object");

        private ReferentialEqualityToObjectEqualityVisitor() {
        }

        private static J.MethodInvocation asEqualsMethodInvocation(J.Binary binary, @Nullable JavaType.FullyQualified selectType) {
            return new J.MethodInvocation(Tree.randomId(), binary.getPrefix(), Markers.EMPTY, new JRightPadded((Object)((Expression)binary.getLeft().withPrefix(Space.EMPTY)), Space.EMPTY, Markers.EMPTY), null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "equals", (JavaType)JavaType.Primitive.Boolean, null), JContainer.build(Collections.singletonList(new JRightPadded((Object)((Expression)binary.getRight().withPrefix(Space.EMPTY)), Space.EMPTY, Markers.EMPTY))), new JavaType.Method(null, Flag.Public.getBitMask(), selectType, "equals", (JavaType)JavaType.Primitive.Boolean, Collections.singletonList("o"), Collections.singletonList(TYPE_OBJECT), null, null, null));
        }

        private static J.Unary asNegatedUnary(J.MethodInvocation mi) {
            return new J.Unary(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded(Space.EMPTY, (Object)J.Unary.Type.Not, Markers.EMPTY), (Expression)mi, (JavaType)JavaType.Primitive.Boolean);
        }

        public J visitBinary(J.Binary binary, ExecutionContext ctx) {
            if (!this.isExcludedBinary(binary)) {
                JavaType.FullyQualified leftType = TypeUtils.asFullyQualified((JavaType)binary.getLeft().getType());
                Optional leftEqualsMethod = TypeUtils.findDeclaredMethod((JavaType.FullyQualified)leftType, (String)"equals", Collections.singletonList(TYPE_OBJECT));
                JavaType.FullyQualified rightType = TypeUtils.asFullyQualified((JavaType)binary.getRight().getType());
                Optional rightEqualsMethod = TypeUtils.findDeclaredMethod((JavaType.FullyQualified)rightType, (String)"equals", Collections.singletonList(TYPE_OBJECT));
                if (leftEqualsMethod.isPresent() && rightEqualsMethod.isPresent()) {
                    JavaType.Method leftEqualsOverride = TypeUtils.findOverriddenMethod((JavaType.Method)((JavaType.Method)leftEqualsMethod.get())).orElse(null);
                    JavaType.Method rightEqualsOverride = TypeUtils.findOverriddenMethod((JavaType.Method)((JavaType.Method)rightEqualsMethod.get())).orElse(null);
                    if (leftEqualsOverride != null && rightEqualsOverride != null && !TypeUtils.isOfClassType((JavaType)((JavaType.Method)leftEqualsMethod.get()).getDeclaringType(), (String)"java.lang.Enum")) {
                        J.MethodInvocation after = null;
                        if (binary.getOperator() == J.Binary.Type.Equal) {
                            after = ReferentialEqualityToObjectEqualityVisitor.asEqualsMethodInvocation(binary, leftType);
                        } else if (binary.getOperator() == J.Binary.Type.NotEqual) {
                            J.MethodInvocation mi = ReferentialEqualityToObjectEqualityVisitor.asEqualsMethodInvocation(binary, leftType);
                            after = ReferentialEqualityToObjectEqualityVisitor.asNegatedUnary(mi);
                        }
                        if (after != null) {
                            return after;
                        }
                    }
                }
            }
            return super.visitBinary(binary, (Object)ctx);
        }

        private boolean isExcludedBinary(J.Binary binary) {
            return this.isInEqualsOverrideMethod() || this.isPrimitiveNull(binary.getRight()) || this.hasThisIdentifier(binary) || this.isBoxedTypeComparison(binary) || TypeUtils.isOfClassType((JavaType)binary.getLeft().getType(), (String)"java.lang.Enum") || TypeUtils.isOfClassType((JavaType)binary.getRight().getType(), (String)"java.lang.Enum");
        }

        private boolean isInEqualsOverrideMethod() {
            J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
            if (md != null && "equals".equals(md.getSimpleName())) {
                return TypeUtils.isOverride((JavaType.Method)md.getMethodType());
            }
            return false;
        }

        private boolean isPrimitiveNull(Expression expression) {
            return expression.getType() == JavaType.Primitive.Null;
        }

        private boolean hasThisIdentifier(J.Binary binary) {
            return binary.getRight() instanceof J.Identifier && "this".equals(((J.Identifier)binary.getRight()).getSimpleName()) || binary.getLeft() instanceof J.Identifier && "this".equals(((J.Identifier)binary.getLeft()).getSimpleName());
        }

        private boolean isBoxedTypeComparison(J.Binary binary) {
            if (binary.getLeft() != null && binary.getLeft().getType() != null && binary.getRight() != null && binary.getRight().getType() != null) {
                return this.isBoxed(binary.getRight().getType()) && this.isBoxed(binary.getLeft().getType());
            }
            return false;
        }

        private boolean isBoxed(JavaType type) {
            return type instanceof JavaType.Primitive || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Byte") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Character") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Short") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Integer") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Long") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Float") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Double") || TypeUtils.isOfClassType((JavaType)type, (String)"java.lang.Boolean");
        }
    }
}

