/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public final class ReplaceDuplicateStringLiterals
extends Recipe {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false)
    @Nullable
    private final Boolean includeTestSources;

    public String getDisplayName() {
        return "Replace duplicate `String` literals";
    }

    public String getDescription() {
        return "Replaces `String` literals with a length of 5 or greater repeated a minimum of 3 times. Qualified `String` literals include final Strings, method invocations, and new class invocations. Adds a new `private static final String` or uses an existing equivalent class field. A new variable name will be generated based on the literal value if an existing field does not exist. The generated name will append a numeric value to the variable name if a name already exists in the compilation unit.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1192");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.lang.String", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                    if (Boolean.TRUE.equals(ReplaceDuplicateStringLiterals.this.includeTestSources) || sourceSet.isPresent() && "main".equals(((JavaSourceSet)sourceSet.get()).getName())) {
                        return (J)super.visit((Tree)cu, (Object)ctx);
                    }
                    return cu;
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getType() == null) {
                    return classDecl;
                }
                Map<String, Set<J.Literal>> duplicateLiteralsMap = FindDuplicateStringLiterals.find(classDecl);
                if (duplicateLiteralsMap.isEmpty()) {
                    return classDecl;
                }
                Set<String> variableNames = FindVariableNames.find(classDecl);
                Map<String, String> fieldValueToFieldName = FindExistingPrivateStaticFinalFields.find((J)classDecl);
                String classFqn = classDecl.getType().getFullyQualifiedName();
                for (String valueOfLiteral : duplicateLiteralsMap.keySet()) {
                    String variableName;
                    if (fieldValueToFieldName.containsKey(valueOfLiteral)) {
                        String classFieldName = fieldValueToFieldName.get(valueOfLiteral);
                        variableName = this.getNameWithoutShadow(classFieldName, variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        if (!classFieldName.equals(variableName)) {
                            this.doAfterVisit((TreeVisitor)new ChangeFieldName(classFqn, classFieldName, variableName));
                        }
                    } else {
                        variableName = this.getNameWithoutShadow(this.transformToVariableName(valueOfLiteral), variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        J.Literal replaceLiteral = ((J.Literal)duplicateLiteralsMap.get(valueOfLiteral).toArray()[0]).withId(Tree.randomId());
                        String insertStatement = "private static final String " + variableName + " = #{any(String)};";
                        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum) {
                            J.EnumValueSet enumValueSet = classDecl.getBody().getStatements().stream().filter(it -> it instanceof J.EnumValueSet).map(it -> (J.EnumValueSet)it).findFirst().orElse(null);
                            if (enumValueSet != null) {
                                Space singleSpace = Space.build((String)" ", Collections.emptyList());
                                J.Literal literal = duplicateLiteralsMap.get(valueOfLiteral).toArray(new J.Literal[0])[0].withId(Tree.randomId());
                                J.Modifier privateModifier = new J.Modifier(Tree.randomId(), Space.build((String)"\n", Collections.emptyList()), Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList());
                                J.Modifier staticModifier = new J.Modifier(Tree.randomId(), singleSpace, Markers.EMPTY, J.Modifier.Type.Static, Collections.emptyList());
                                J.Modifier finalModifier = new J.Modifier(Tree.randomId(), singleSpace, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList());
                                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)this.autoFormat((J)new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Arrays.asList(privateModifier, staticModifier, finalModifier), (TypeTree)new J.Identifier(Tree.randomId(), singleSpace, Markers.EMPTY, "String", (JavaType)JavaType.ShallowClass.build((String)"java.lang.String"), null), null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, variableName, (JavaType)JavaType.ShallowClass.build((String)"java.lang.String"), null), Collections.emptyList(), JLeftPadded.build((Object)literal).withBefore(singleSpace), null)))), ctx, new Cursor(this.getCursor(), (Object)classDecl.getBody()));
                                ArrayList<Object> statements = new ArrayList<Object>(classDecl.getBody().getStatements().size() + 1);
                                boolean addedNewStatement = false;
                                for (Statement statement : classDecl.getBody().getStatements()) {
                                    if (!(statement instanceof J.EnumValueSet) && !addedNewStatement) {
                                        statements.add(variableDeclarations);
                                        addedNewStatement = true;
                                    }
                                    statements.add(statement);
                                }
                                classDecl = classDecl.withBody(classDecl.getBody().withStatements(statements));
                            }
                        } else {
                            classDecl = classDecl.withBody((J.Block)JavaTemplate.builder((String)insertStatement).contextSensitive().build().apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().firstStatement(), new Object[]{replaceLiteral}));
                        }
                    }
                    variableNames.add(variableName);
                    this.doAfterVisit((TreeVisitor)new ReplaceStringLiterals(classDecl, variableName, duplicateLiteralsMap.get(valueOfLiteral)));
                }
                return classDecl;
            }

            private String getNameWithoutShadow(String name, Set<String> variableNames) {
                String transformedName;
                String newName = transformedName = this.transformToVariableName(name);
                int append = 0;
                while (variableNames.contains(newName)) {
                    newName = transformedName + "_" + ++append;
                }
                return newName;
            }

            private String transformToVariableName(String valueOfLiteral) {
                boolean prevIsLower = false;
                boolean prevIsCharacter = false;
                StringBuilder newName = new StringBuilder();
                for (int i = 0; i < valueOfLiteral.length(); ++i) {
                    char c = valueOfLiteral.charAt(i);
                    if (i > 0 && newName.lastIndexOf("_") != newName.length() - 1 && (Character.isUpperCase(c) && prevIsLower || !prevIsCharacter)) {
                        newName.append("_");
                    }
                    if (!(prevIsCharacter = Character.isLetterOrDigit(c))) continue;
                    if (newName.length() == 0 && Character.isDigit(c)) {
                        newName.append("A_");
                    }
                    newName.append(Character.toUpperCase(c));
                    prevIsLower = Character.isLowerCase(c);
                }
                return VariableNameUtils.normalizeName((String)newName.toString());
            }
        });
    }

    private static boolean isPrivateStaticFinalVariable(J.VariableDeclarations declaration) {
        return declaration.hasModifier(J.Modifier.Type.Private) && declaration.hasModifier(J.Modifier.Type.Static) && declaration.hasModifier(J.Modifier.Type.Final);
    }

    public ReplaceDuplicateStringLiterals(Boolean includeTestSources) {
        this.includeTestSources = includeTestSources;
    }

    public Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    public String toString() {
        return "ReplaceDuplicateStringLiterals(includeTestSources=" + this.getIncludeTestSources() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceDuplicateStringLiterals)) {
            return false;
        }
        ReplaceDuplicateStringLiterals other = (ReplaceDuplicateStringLiterals)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        return !(this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplaceDuplicateStringLiterals;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        return result;
    }

    private static class ReplaceStringLiterals
    extends JavaVisitor<ExecutionContext> {
        private final J.ClassDeclaration isClass;
        private final String variableName;
        private final Set<J.Literal> literals;

        private ReplaceStringLiterals(J.ClassDeclaration isClass, String variableName, Set<J.Literal> literals) {
            this.isClass = isClass;
            this.variableName = variableName;
            this.literals = literals;
        }

        public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
            if (this.literals.contains(literal)) {
                assert (this.isClass.getType() != null);
                return new J.Identifier(Tree.randomId(), literal.getPrefix(), literal.getMarkers(), this.variableName, (JavaType)JavaType.Primitive.String, new JavaType.Variable(null, Flag.flagsToBitMap(new HashSet<Flag>(Arrays.asList(Flag.Private, Flag.Static, Flag.Final))), this.variableName, (JavaType)this.isClass.getType(), (JavaType)JavaType.Primitive.String, Collections.emptyList()));
            }
            return literal;
        }
    }

    private static class FindExistingPrivateStaticFinalFields
    extends JavaIsoVisitor<Map<String, String>> {
        private FindExistingPrivateStaticFinalFields() {
        }

        public static Map<String, String> find(J j) {
            LinkedHashMap<String, String> fieldValueToFieldName = new LinkedHashMap<String, String>();
            new FindExistingPrivateStaticFinalFields().visit((Tree)j, fieldValueToFieldName);
            return fieldValueToFieldName;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Map<String, String> valueToVariable) {
            Cursor parentScope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration);
            J.VariableDeclarations declaration = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
            if (parentScope.getValue() instanceof J.ClassDeclaration && declaration != null && ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(declaration) && variable.getInitializer() instanceof J.Literal && ((J.Literal)variable.getInitializer()).getValue() instanceof String) {
                String value = (String)((J.Literal)variable.getInitializer()).getValue();
                valueToVariable.putIfAbsent(value, variable.getSimpleName());
            }
            return variable;
        }
    }

    private static class FindVariableNames
    extends JavaIsoVisitor<Set<String>> {
        private FindVariableNames() {
        }

        public static Set<String> find(J.ClassDeclaration inClass) {
            HashSet<String> variableNames = new HashSet<String>();
            new FindVariableNames().visit((Tree)inClass, variableNames);
            return variableNames;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<String> variableNames) {
            Cursor parentScope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration);
            J.VariableDeclarations declaration = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
            if (parentScope.getValue() instanceof J.MethodDeclaration || parentScope.getValue() instanceof J.ClassDeclaration && declaration != null && (!ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(declaration) || !(variable.getInitializer() instanceof J.Literal) || !(((J.Literal)variable.getInitializer()).getValue() instanceof String))) {
                variableNames.add(variable.getSimpleName());
            }
            return variable;
        }
    }

    private static class FindDuplicateStringLiterals
    extends JavaIsoVisitor<Map<String, Set<J.Literal>>> {
        private FindDuplicateStringLiterals() {
        }

        public static Map<String, Set<J.Literal>> find(J.ClassDeclaration inClass) {
            HashMap literalsMap = new HashMap();
            TreeMap<String, Set<J.Literal>> filteredMap = new TreeMap<String, Set<J.Literal>>(Comparator.reverseOrder());
            new FindDuplicateStringLiterals().visit((Tree)inClass, literalsMap);
            for (String valueOfLiteral : literalsMap.keySet()) {
                if (((Set)literalsMap.get(valueOfLiteral)).size() < 3) continue;
                filteredMap.put(valueOfLiteral, (Set)literalsMap.get(valueOfLiteral));
            }
            return filteredMap;
        }

        public J.Literal visitLiteral(J.Literal literal, Map<String, Set<J.Literal>> literalsMap) {
            if (JavaType.Primitive.String.equals((Object)literal.getType()) && literal.getValue() instanceof String && ((String)literal.getValue()).length() >= 5) {
                Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Annotation || is instanceof J.VariableDeclarations || is instanceof J.NewClass || is instanceof J.MethodInvocation);
                if (parent.getValue() instanceof J.NewClass && parent.firstEnclosing(J.EnumValueSet.class) != null) {
                    return literal;
                }
                if (parent.getValue() instanceof J.VariableDeclarations && ((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Final) && (!((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Private) || !((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Static)) || parent.getValue() instanceof J.NewClass || parent.getValue() instanceof J.MethodInvocation) {
                    literalsMap.computeIfAbsent((String)literal.getValue(), k -> new HashSet());
                    literalsMap.get((String)literal.getValue()).add(literal);
                }
            }
            return literal;
        }
    }
}

