/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.staticanalysis.JavaElementFactory;

public class ReplaceLambdaWithMethodReference
extends Recipe {
    public String getDisplayName() {
        return "Use method references in lambda";
    }

    public String getDescription() {
        return "Replaces the single statement lambdas `o -> o instanceOf X`, `o -> (A) o`, `o -> System.out.println(o)`, `o -> o != null`, `o -> o == null` with the equivalent method reference.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1612");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                if (tree instanceof J.CompilationUnit) {
                    return new ReplaceLambdaWithMethodReferenceJavaVisitor().visit(tree, ctx);
                }
                if (tree instanceof K.CompilationUnit) {
                    return new ReplaceLambdaWithMethodReferenceKotlinVisitor().visit(tree, ctx);
                }
                return tree;
            }
        };
    }

    private static boolean isAMethodInvocationArgument(J.Lambda lambda, Cursor cursor) {
        Cursor parent = cursor.dropParentUntil(p -> p instanceof J.MethodInvocation || p instanceof J.CompilationUnit);
        if (parent.getValue() instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)parent.getValue();
            return m.getArguments().stream().anyMatch(arg -> arg == lambda);
        }
        return false;
    }

    private static class ReplaceLambdaWithMethodReferenceJavaVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceLambdaWithMethodReferenceJavaVisitor() {
        }

        public J visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
            JavaType.FullyQualified classType;
            Optional<JavaType.Method> castMethod;
            J.ControlParentheses j;
            J tree;
            J.FieldAccess classLiteral;
            J.Lambda l = (J.Lambda)super.visitLambda(lambda, (Object)executionContext);
            this.updateCursor((Tree)l);
            String code = "";
            J body = l.getBody();
            if (body instanceof J.Block && ((J.Block)body).getStatements().size() == 1) {
                Statement statement = (Statement)((J.Block)body).getStatements().get(0);
                if (statement instanceof J.MethodInvocation) {
                    body = statement;
                } else if (statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof MethodCall) {
                    body = ((J.Return)statement).getExpression();
                }
            } else if (body instanceof J.InstanceOf) {
                JavaType.FullyQualified rawClassType;
                Optional<JavaType.Method> isInstanceMethod;
                J.InstanceOf instanceOf = (J.InstanceOf)body;
                J j2 = instanceOf.getClazz();
                if ((j2 instanceof J.Identifier || j2 instanceof J.FieldAccess) && instanceOf.getExpression() instanceof J.Identifier && (classLiteral = JavaElementFactory.newClassLiteral(((TypeTree)j2).getType(), j2 instanceof J.FieldAccess)) != null && (isInstanceMethod = (rawClassType = ((JavaType.Parameterized)classLiteral.getType()).getType()).getMethods().stream().filter(m -> m.getName().equals("isInstance")).findFirst()).isPresent()) {
                    return JavaElementFactory.newInstanceMethodReference(isInstanceMethod.get(), (Expression)classLiteral, lambda.getType()).withPrefix(lambda.getPrefix());
                }
            } else if (body instanceof J.TypeCast && !(((J.TypeCast)body).getExpression() instanceof J.MethodInvocation) && ((tree = (j = ((J.TypeCast)body).getClazz()).getTree()) instanceof J.Identifier || tree instanceof J.FieldAccess) && !(j.getType() instanceof JavaType.GenericTypeVariable) && (classLiteral = JavaElementFactory.newClassLiteral(((Expression)tree).getType(), tree instanceof J.FieldAccess)) != null && (castMethod = (classType = ((JavaType.Parameterized)classLiteral.getType()).getType()).getMethods().stream().filter(m -> m.getName().equals("cast")).findFirst()).isPresent()) {
                return JavaElementFactory.newInstanceMethodReference(castMethod.get(), (Expression)classLiteral, lambda.getType()).withPrefix(lambda.getPrefix());
            }
            if (body instanceof J.Binary) {
                J.Binary binary = (J.Binary)body;
                if (this.isNullCheck((J)binary.getLeft(), (J)binary.getRight()) || this.isNullCheck((J)binary.getRight(), (J)binary.getLeft())) {
                    this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                    code = J.Binary.Type.Equal.equals((Object)binary.getOperator()) ? "java.util.Objects::isNull" : "java.util.Objects::nonNull";
                    return JavaTemplate.builder((String)code).contextSensitive().build().apply(this.getCursor(), l.getCoordinates().replace(), new Object[0]);
                }
            } else if (body instanceof MethodCall) {
                MethodCall method = (MethodCall)body;
                if (method instanceof J.NewClass) {
                    J.NewClass nc = (J.NewClass)method;
                    if (nc.getBody() != null) {
                        return l;
                    }
                    if (ReplaceLambdaWithMethodReference.isAMethodInvocationArgument(l, this.getCursor()) && nc.getType() instanceof JavaType.Class) {
                        boolean hasMultipleConstructors;
                        JavaType.Class clazz = (JavaType.Class)nc.getType();
                        boolean bl = hasMultipleConstructors = clazz.getMethods().stream().filter(JavaType.Method::isConstructor).count() > 1L;
                        if (hasMultipleConstructors) {
                            return l;
                        }
                    }
                }
                if (this.multipleMethodInvocations(method) || !this.methodArgumentsMatchLambdaParameters(method, lambda) || method instanceof J.MemberReference) {
                    return l;
                }
                Expression select = method instanceof J.MethodInvocation ? ((J.MethodInvocation)method).getSelect() : null;
                JavaType.Method methodType = method.getMethodType();
                if (methodType != null) {
                    if (methodType.hasFlags(new Flag[]{Flag.Static}) || this.methodSelectMatchesFirstLambdaParameter(method, lambda)) {
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        return JavaElementFactory.newStaticMethodReference(methodType, true, lambda.getType()).withPrefix(lambda.getPrefix());
                    }
                    if (method instanceof J.NewClass) {
                        return JavaTemplate.builder((String)"#{}::new").contextSensitive().build().apply(this.getCursor(), l.getCoordinates().replace(), new Object[]{this.className((J.NewClass)method)});
                    }
                    if (select != null) {
                        return JavaElementFactory.newInstanceMethodReference(methodType, select, lambda.getType()).withPrefix(lambda.getPrefix());
                    }
                    String templ = "#{}::#{}";
                    return JavaTemplate.builder((String)templ).contextSensitive().build().apply(this.getCursor(), l.getCoordinates().replace(), new Object[]{"this", method.getMethodType().getName()});
                }
            }
            return l;
        }

        private String className(J.NewClass method) {
            TypeTree clazz = method.getClazz();
            return clazz instanceof J.ParameterizedType ? ((J.ParameterizedType)clazz).getClazz().toString() : Objects.toString(clazz);
        }

        private boolean multipleMethodInvocations(MethodCall method) {
            return method instanceof J.MethodInvocation && ((J.MethodInvocation)method).getSelect() instanceof J.MethodInvocation;
        }

        private boolean methodArgumentsMatchLambdaParameters(MethodCall method, J.Lambda lambda) {
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return false;
            }
            boolean static_ = methodType.hasFlags(new Flag[]{Flag.Static});
            List methodArgs = method.getArguments().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toList());
            List lambdaParameters = lambda.getParameters().getParameters().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(v -> (J.VariableDeclarations.NamedVariable)v.getVariables().get(0)).collect(Collectors.toList());
            if (methodArgs.isEmpty() && lambdaParameters.isEmpty()) {
                return true;
            }
            if (!static_ && this.methodSelectMatchesFirstLambdaParameter(method, lambda)) {
                methodArgs.add(0, ((J.MethodInvocation)method).getSelect());
            }
            if (methodArgs.size() != lambdaParameters.size()) {
                return false;
            }
            for (int i = 0; i < lambdaParameters.size(); ++i) {
                JavaType.Variable lambdaParam = ((J.VariableDeclarations.NamedVariable)lambdaParameters.get(i)).getVariableType();
                if (!(methodArgs.get(i) instanceof J.Identifier)) {
                    return false;
                }
                JavaType.Variable methodArgument = ((J.Identifier)methodArgs.get(i)).getFieldType();
                if (lambdaParam == methodArgument) continue;
                return false;
            }
            return true;
        }

        private boolean methodSelectMatchesFirstLambdaParameter(MethodCall method, J.Lambda lambda) {
            if (!(method instanceof J.MethodInvocation) || !(((J.MethodInvocation)method).getSelect() instanceof J.Identifier) || lambda.getParameters().getParameters().isEmpty() || !(lambda.getParameters().getParameters().get(0) instanceof J.VariableDeclarations)) {
                return false;
            }
            J.VariableDeclarations firstLambdaParameter = (J.VariableDeclarations)lambda.getParameters().getParameters().get(0);
            return ((J.Identifier)((J.MethodInvocation)method).getSelect()).getFieldType() == ((J.VariableDeclarations.NamedVariable)firstLambdaParameter.getVariables().get(0)).getVariableType();
        }

        private boolean isNullCheck(J j1, J j2) {
            return j1 instanceof J.Identifier && j2 instanceof J.Literal && "null".equals(((J.Literal)j2).getValueSource());
        }
    }

    private static class ReplaceLambdaWithMethodReferenceKotlinVisitor
    extends KotlinVisitor<ExecutionContext> {
        private ReplaceLambdaWithMethodReferenceKotlinVisitor() {
        }
    }
}

