/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceWeekYearWithYear
extends Recipe {
    private static final MethodMatcher SIMPLE_DATE_FORMAT_CONSTRUCTOR_MATCHER = new MethodMatcher("java.text.SimpleDateFormat <constructor>(..)");
    private static final MethodMatcher OF_PATTERN_MATCHER = new MethodMatcher("java.time.format.DateTimeFormatter ofPattern(..)");

    public String getDisplayName() {
        return "Week Year (YYYY) should not be used for date formatting";
    }

    public String getDescription() {
        return "For most dates Week Year (YYYY) and Year (yyyy) yield the same results. However, on the last week of December and first week of January Week Year could produce unexpected results.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3986");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Date", Boolean.valueOf(false)), new UsesType("java.time.format.DateTimeFormatter", Boolean.valueOf(false)), new UsesType("java.text.SimpleDateFormat", Boolean.valueOf(false))}), (TreeVisitor)new ReplaceWeekYearVisitor());
    }

    private static class ReplaceWeekYearVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ReplaceWeekYearVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
            if (OF_PATTERN_MATCHER.matches((MethodCall)mi)) {
                this.getCursor().putMessage("KEY", (Object)mi);
            }
            return super.visitMethodInvocation(mi, (Object)ctx);
        }

        public J.NewClass visitNewClass(J.NewClass nc, ExecutionContext ctx) {
            if (SIMPLE_DATE_FORMAT_CONSTRUCTOR_MATCHER.matches((MethodCall)nc)) {
                this.getCursor().putMessage("KEY", (Object)nc);
            }
            return super.visitNewClass(nc, (Object)ctx);
        }

        public J.Literal visitLiteral(J.Literal li, ExecutionContext ctx) {
            Cursor c;
            if (li.getValue() instanceof String && (c = this.getCursor().dropParentWhile(is -> is instanceof J.Parentheses || !(is instanceof Tree))).getMessage("KEY") != null) {
                Object value = li.getValue();
                if (value == null) {
                    return li;
                }
                String newValue = ReplaceWeekYearVisitor.replaceY(value.toString());
                if (newValue.equals(value.toString())) {
                    return li;
                }
                return li.withValueSource("\"" + newValue + "\"").withValue((Object)newValue);
            }
            return li;
        }

        public static String replaceY(String input) {
            StringBuilder output = new StringBuilder();
            boolean insideQuotes = false;
            for (int i = 0; i < input.length(); ++i) {
                char nextChar;
                char currentChar = input.charAt(i);
                char c = nextChar = i < input.length() - 1 ? input.charAt(i + 1) : (char)'\u0000';
                if (currentChar == '\'') {
                    insideQuotes = !insideQuotes;
                    output.append(currentChar);
                    continue;
                }
                if (currentChar == 'Y' && !insideQuotes) {
                    output.append('y');
                    continue;
                }
                if (currentChar == 'Y' && nextChar == '\'') {
                    output.append(currentChar);
                    continue;
                }
                output.append(currentChar);
            }
            return output.toString();
        }
    }
}

