/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class ModifierOrder
extends Recipe {
    public String getDisplayName() {
        return "Modifier order";
    }

    public String getDescription() {
        return "Modifiers should be declared in the correct order as recommended by the JLS.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1124");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)executionContext);
                return c.withModifiers(ModifierOrder.sortModifiers(c.getModifiers()));
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)executionContext);
                return m.withModifiers(ModifierOrder.sortModifiers(m.getModifiers()));
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, (Object)executionContext);
                return v.withModifiers(ModifierOrder.sortModifiers(v.getModifiers()));
            }
        };
    }

    public static List<J.Modifier> sortModifiers(List<J.Modifier> modifiers) {
        for (J.Modifier mod2 : modifiers) {
            if (mod2.getType() != J.Modifier.Type.LanguageExtension) continue;
            return modifiers;
        }
        List sortedTypes = modifiers.stream().map(J.Modifier::getType).sorted(Comparator.comparingInt(Enum::ordinal)).collect(Collectors.toList());
        return ListUtils.map(modifiers, (i, mod) -> mod.getType() == sortedTypes.get((int)i) ? mod : mod.withType((J.Modifier.Type)sortedTypes.get((int)i)));
    }
}

