/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class IsEmptyCallOnCollections
extends Recipe {
    private static final MethodMatcher COLLECTION_SIZE = new MethodMatcher("java.util.Collection size()", true);

    public String getDisplayName() {
        return "Use `Collection#isEmpty()` instead of comparing `size()`";
    }

    public String getDescription() {
        return "Also check for _not_ `isEmpty()` when testing for not equal to zero size.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1155", "RSPEC-3981"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(COLLECTION_SIZE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final JavaTemplate isEmpty = JavaTemplate.builder((String)"#{}#{any(java.util.Collection)}.isEmpty()").contextSensitive().build();
            final JavaTemplate isEmptyNoReceiver = JavaTemplate.builder((String)"#{}isEmpty()").contextSensitive().build();

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                if (IsEmptyCallOnCollections.isZero(binary.getLeft()) || IsEmptyCallOnCollections.isZero(binary.getRight())) {
                    Expression maybeSizeCall;
                    boolean zeroRight = IsEmptyCallOnCollections.isZero(binary.getRight());
                    Expression expression = maybeSizeCall = zeroRight ? binary.getLeft() : binary.getRight();
                    if ((binary.getOperator() == J.Binary.Type.Equal || binary.getOperator() == J.Binary.Type.NotEqual || zeroRight && binary.getOperator() == J.Binary.Type.GreaterThan || !zeroRight && binary.getOperator() == J.Binary.Type.LessThan) && maybeSizeCall instanceof J.MethodInvocation) {
                        J.MethodInvocation maybeSizeCallMethod = (J.MethodInvocation)maybeSizeCall;
                        if (COLLECTION_SIZE.matches((MethodCall)maybeSizeCallMethod)) {
                            String op = binary.getOperator() == J.Binary.Type.Equal ? "" : "!";
                            return (maybeSizeCallMethod.getSelect() == null ? this.isEmptyNoReceiver.apply(this.getCursor(), binary.getCoordinates().replace(), new Object[]{op}) : this.isEmpty.apply(this.getCursor(), binary.getCoordinates().replace(), new Object[]{op, maybeSizeCallMethod.getSelect()})).withPrefix(binary.getPrefix());
                        }
                    }
                }
                return super.visitBinary(binary, (Object)ctx);
            }
        });
    }

    private static boolean isZero(Expression expression) {
        return expression instanceof J.Literal && Integer.valueOf(0).equals(((J.Literal)expression).getValue());
    }
}

