/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class CompareEnumsWithEqualityOperator
extends Recipe {
    public String getDisplayName() {
        return "Enum values should be compared with \"==\"";
    }

    public String getDescription() {
        return "Replaces `Enum equals(java.lang.Object)` with `Enum == java.lang.Object`. An `!Enum equals(java.lang.Object)` will change to `!=`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4551");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher enumEquals = new MethodMatcher("java.lang.Enum equals(java.lang.Object)");
        return Preconditions.check((TreeVisitor)new UsesMethod(enumEquals), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (enumEquals.matches((MethodCall)m) && m.getSelect() != null) {
                    boolean isNot;
                    Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.Unary || is instanceof J.Block);
                    boolean bl = isNot = parent.getValue() instanceof J.Unary && ((J.Unary)parent.getValue()).getOperator() == J.Unary.Type.Not;
                    if (isNot) {
                        parent.putMessage("REMOVE_UNARY_NOT", parent.getValue());
                    }
                    String code = "#{any()} " + (isNot ? "!=" : "==") + " #{any()}";
                    return this.autoFormat(JavaTemplate.builder((String)code).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{m.getSelect(), m.getArguments().get(0)}), ctx);
                }
                return m;
            }

            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J j = super.visitUnary(unary, (Object)ctx);
                J.Unary asUnary = (J.Unary)j;
                if (asUnary.equals(this.getCursor().pollMessage("REMOVE_UNARY_NOT"))) {
                    return asUnary.getExpression().unwrap().withPrefix(asUnary.getPrefix());
                }
                return j;
            }
        });
    }
}

