/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Comparator;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.0.0")
public class CovariantEqualsVisitor<P>
extends JavaIsoVisitor<P> {
    private static final MethodMatcher OBJECT_EQUALS = new MethodMatcher("* equals(java.lang.Object)");

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, p);
        Stream<J.MethodDeclaration> mds = cd.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast);
        if (cd.getKind() != J.ClassDeclaration.Kind.Type.Interface && mds.noneMatch(m -> OBJECT_EQUALS.matches(m, classDecl))) {
            cd = (J.ClassDeclaration)new ChangeCovariantEqualsMethodVisitor(cd).visit((Tree)cd, p, this.getCursor().getParentOrThrow());
            assert (cd != null);
        }
        return cd;
    }

    private static class ChangeCovariantEqualsMethodVisitor<P>
    extends JavaIsoVisitor<P> {
        private static final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");
        private static final String EQUALS_BODY_PREFIX_TEMPLATE = "if (#{} == this) return true;\nif (#{} == null || getClass() != #{}.getClass()) return false;\n#{} #{} = (#{}) #{};\n";
        private final J.ClassDeclaration enclosingClass;

        public ChangeCovariantEqualsMethodVisitor(J.ClassDeclaration enclosingClass) {
            this.enclosingClass = enclosingClass;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
            JavaType.FullyQualified type = this.enclosingClass.getType();
            if (type == null || type instanceof JavaType.Unknown) {
                return m;
            }
            String ecfqn = type.getFullyQualifiedName();
            if (m.hasModifier(J.Modifier.Type.Public) && m.getReturnTypeExpression() != null && JavaType.Primitive.Boolean.equals((Object)m.getReturnTypeExpression().getType()) && new MethodMatcher(ecfqn + " equals(" + ecfqn + ")").matches(m, this.enclosingClass)) {
                J.VariableDeclarations.NamedVariable oldParamName;
                if (m.getAllAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)OVERRIDE_ANNOTATION).matches(arg_0))) {
                    m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Override").build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                String paramName = "obj".equals((oldParamName = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)m.getParameters().get(0)).getVariables().get(0)).getSimpleName()) ? "other" : "obj";
                m = (J.MethodDeclaration)JavaTemplate.builder((String)"Object #{}").build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceParameters(), new Object[]{paramName});
                JavaTemplate equalsBodySnippet = JavaTemplate.builder((String)EQUALS_BODY_PREFIX_TEMPLATE).contextSensitive().build();
                assert (m.getBody() != null);
                Object[] params = new Object[]{paramName, paramName, paramName, this.enclosingClass.getSimpleName(), oldParamName.getSimpleName(), this.enclosingClass.getSimpleName(), paramName};
                m = (J.MethodDeclaration)equalsBodySnippet.apply(new Cursor(this.getCursor().getParent(), (Object)m), ((Statement)m.getBody().getStatements().get(0)).getCoordinates().before(), params);
            }
            return m;
        }
    }
}

