/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class FinalizePrivateFields
extends Recipe {
    public String getDisplayName() {
        return "Finalize private fields";
    }

    public String getDescription() {
        return "Adds the `final` modifier keyword to private instance variables which are not reassigned.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private Set<JavaType.Variable> privateFieldsToBeFinalized = new HashSet<JavaType.Variable>();

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (!((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor()).isEmpty()) {
                    return classDecl;
                }
                if (FinalizePrivateFields.getConstructorCount(classDecl) > 1 || FinalizePrivateFields.isInnerClass(classDecl)) {
                    return classDecl;
                }
                List<J.VariableDeclarations.NamedVariable> privateFields = this.collectPrivateFields(this.getCursor());
                Map<JavaType.Variable, Integer> privateFieldAssignCountMap = privateFields.stream().filter(v -> v.getVariableType() != null).collect(Collectors.toMap(J.VariableDeclarations.NamedVariable::getVariableType, v -> v.getInitializer() != null ? 1 : 0));
                CollectPrivateFieldsAssignmentCounts.collect((J)classDecl, privateFieldAssignCountMap);
                this.privateFieldsToBeFinalized = privateFieldAssignCountMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                boolean canAllVariablesBeFinalized = mv.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getVariableType).allMatch(this.privateFieldsToBeFinalized::contains);
                if (canAllVariablesBeFinalized) {
                    mv = (J.VariableDeclarations)this.autoFormat((J)mv.withVariables(ListUtils.map((List)mv.getVariables(), v -> {
                        JavaType.Variable type = v.getVariableType();
                        return type != null ? v.withVariableType(type.withFlags(Flag.bitMapToFlags((long)(type.getFlagsBitMap() | Flag.Final.getBitMask())))) : null;
                    })).withModifiers(ListUtils.concat((List)mv.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList()))), ctx);
                }
                return mv;
            }

            private boolean anyAnnotationApplied(Cursor variableCursor) {
                return !((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(variableCursor).isEmpty() || ((J.VariableDeclarations)variableCursor.getValue()).getTypeExpression() instanceof J.AnnotatedType;
            }

            private List<J.VariableDeclarations.NamedVariable> collectPrivateFields(Cursor classCursor) {
                J.ClassDeclaration classDecl = (J.ClassDeclaration)classCursor.getValue();
                Cursor bodyCursor = new Cursor(classCursor, (Object)classDecl.getBody());
                return classDecl.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).filter(mv -> mv.hasModifier(J.Modifier.Type.Private) && !mv.hasModifier(J.Modifier.Type.Final) && !mv.hasModifier(J.Modifier.Type.Volatile)).filter(mv -> !this.anyAnnotationApplied(new Cursor(bodyCursor, mv))).map(J.VariableDeclarations::getVariables).flatMap(Collection::stream).collect(Collectors.toList());
            }
        };
    }

    private static int getConstructorCount(J.ClassDeclaration classDecl) {
        return (int)classDecl.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(J.MethodDeclaration::isConstructor).count();
    }

    private static boolean isInnerClass(J.ClassDeclaration classDecl) {
        return classDecl.getType() != null && classDecl.getType().getOwningClass() != null;
    }

    private static final class FindLastIdentifier
    extends JavaIsoVisitor<List<J.Identifier>> {
        @Nullable
        static J.Identifier getLastIdentifier(J j) {
            List ids = (List)new FindLastIdentifier().reduce((Tree)j, new ArrayList());
            return !ids.isEmpty() ? (J.Identifier)ids.get(ids.size() - 1) : null;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, List<J.Identifier> ids) {
            ids.add(identifier);
            return super.visitIdentifier(identifier, ids);
        }

        @Generated
        public FindLastIdentifier() {
        }

        @Generated
        public String toString() {
            return "FinalizePrivateFields.FindLastIdentifier()";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindLastIdentifier)) {
                return false;
            }
            FindLastIdentifier other = (FindLastIdentifier)((Object)o);
            return other.canEqual((Object)this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FindLastIdentifier;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    private static class CollectPrivateFieldsAssignmentCounts
    extends JavaIsoVisitor<Map<JavaType.Variable, Integer>> {
        private CollectPrivateFieldsAssignmentCounts() {
        }

        static void collect(J j, Map<JavaType.Variable, Integer> assignedCountMap) {
            new CollectPrivateFieldsAssignmentCounts().visit((Tree)j, assignedCountMap);
        }

        public J.Assignment visitAssignment(J.Assignment assignment, Map<JavaType.Variable, Integer> assignedCountMap) {
            J.Assignment a = super.visitAssignment(assignment, assignedCountMap);
            CollectPrivateFieldsAssignmentCounts.updateAssignmentCount(this.getCursor(), a.getVariable(), assignedCountMap);
            return a;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, Map<JavaType.Variable, Integer> assignedCountMap) {
            J.AssignmentOperation a = super.visitAssignmentOperation(assignOp, assignedCountMap);
            CollectPrivateFieldsAssignmentCounts.updateAssignmentCount(this.getCursor(), a.getVariable(), assignedCountMap);
            return a;
        }

        public J.Unary visitUnary(J.Unary unary, Map<JavaType.Variable, Integer> assignedCountMap) {
            J.Unary u = super.visitUnary(unary, assignedCountMap);
            if (u.getOperator().isModifying()) {
                CollectPrivateFieldsAssignmentCounts.updateAssignmentCount(this.getCursor(), u.getExpression(), assignedCountMap);
            }
            return u;
        }

        private static void updateAssignmentCount(Cursor cursor, Expression expression, Map<JavaType.Variable, Integer> assignedCountMap) {
            J.Identifier i;
            JavaType.Variable privateField = null;
            if (expression instanceof J.FieldAccess) {
                J.Identifier lastId = FindLastIdentifier.getLastIdentifier((J)expression);
                if (lastId != null && assignedCountMap.containsKey(lastId.getFieldType())) {
                    privateField = lastId.getFieldType();
                }
            } else if (expression instanceof J.Identifier && assignedCountMap.containsKey((i = (J.Identifier)expression).getFieldType())) {
                privateField = i.getFieldType();
            }
            if (privateField != null) {
                int assignedCount = assignedCountMap.get(privateField);
                int increment = CollectPrivateFieldsAssignmentCounts.isInLoop(cursor) || CollectPrivateFieldsAssignmentCounts.isInLambda(cursor) ? 2 : (CollectPrivateFieldsAssignmentCounts.isInitializedByClass(cursor, privateField.hasFlags(new Flag[]{Flag.Static})) ? 1 : 2);
                assignedCountMap.put(privateField, assignedCount + increment);
            }
        }

        private static boolean isInLoop(Cursor cursor) {
            return CollectPrivateFieldsAssignmentCounts.isInForLoop(cursor) || CollectPrivateFieldsAssignmentCounts.isInDoWhileLoopLoop(cursor) || CollectPrivateFieldsAssignmentCounts.isInWhileLoop(cursor);
        }

        private static boolean isInitializedByClass(Cursor cursor, boolean privateFieldIsStatic) {
            Object parent = cursor.dropParentWhile(p -> p instanceof J.Block && !((J.Block)p).isStatic() || p instanceof JRightPadded || p instanceof JLeftPadded).getValue();
            if (parent instanceof J.Block) {
                return privateFieldIsStatic;
            }
            if (privateFieldIsStatic) {
                return false;
            }
            if (parent instanceof J.MethodDeclaration) {
                return ((J.MethodDeclaration)parent).isConstructor();
            }
            return parent instanceof J.ClassDeclaration;
        }

        private static boolean dropCursorEndCondition(Object parent) {
            return parent instanceof J.ClassDeclaration || parent instanceof J.MethodDeclaration;
        }

        private static boolean dropUntilMeetCondition(Cursor cursor, Predicate<Object> endCondition, Predicate<Object> condition) {
            return condition.test(cursor.dropParentUntil(parent -> endCondition.test(parent) || condition.test(parent)).getValue());
        }

        private static boolean isInForLoop(Cursor cursor) {
            return CollectPrivateFieldsAssignmentCounts.dropUntilMeetCondition(cursor, CollectPrivateFieldsAssignmentCounts::dropCursorEndCondition, J.ForLoop.class::isInstance);
        }

        private static boolean isInDoWhileLoopLoop(Cursor cursor) {
            return CollectPrivateFieldsAssignmentCounts.dropUntilMeetCondition(cursor, CollectPrivateFieldsAssignmentCounts::dropCursorEndCondition, J.DoWhileLoop.class::isInstance);
        }

        private static boolean isInWhileLoop(Cursor cursor) {
            return CollectPrivateFieldsAssignmentCounts.dropUntilMeetCondition(cursor, CollectPrivateFieldsAssignmentCounts::dropCursorEndCondition, J.WhileLoop.class::isInstance);
        }

        private static boolean isInLambda(Cursor cursor) {
            return CollectPrivateFieldsAssignmentCounts.dropUntilMeetCondition(cursor, CollectPrivateFieldsAssignmentCounts::dropCursorEndCondition, J.Lambda.class::isInstance);
        }
    }
}

