/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.FallThroughStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class FallThroughVisitor<P>
extends JavaIsoVisitor<P> {
    private static final Pattern RELIEF_PATTERN = Pattern.compile("falls?[ -]?thr(u|ough)");
    private final FallThroughStyle style;

    private static boolean isLastCase(J.Case case_, J.Switch switch_) {
        J.Block switchBlock = switch_.getCases();
        return case_ == switchBlock.getStatements().get(switchBlock.getStatements().size() - 1);
    }

    public J.Case visitCase(J.Case case_, P p) {
        J.Case c = super.visitCase(case_, p);
        if (this.getCursor().firstEnclosing(J.Switch.class) != null) {
            J.Switch switch_ = (J.Switch)this.getCursor().dropParentUntil(J.Switch.class::isInstance).getValue();
            if ((Boolean.TRUE.equals(this.style.getCheckLastCaseGroup()) || !FallThroughVisitor.isLastCase(case_, switch_)) && FindLastLineBreaksOrFallsThroughComments.find(switch_, c).isEmpty()) {
                c = (J.Case)new AddBreak(c).visit((Tree)c, p, this.getCursor().getParent());
            }
        }
        return c;
    }

    @Generated
    public FallThroughVisitor(FallThroughStyle style) {
        this.style = style;
    }

    @Generated
    public FallThroughStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "FallThroughVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FallThroughVisitor)) {
            return false;
        }
        FallThroughVisitor other = (FallThroughVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FallThroughStyle this$style = this.getStyle();
        FallThroughStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FallThroughVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FallThroughStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    private static class FindLastLineBreaksOrFallsThroughComments {
        private FindLastLineBreaksOrFallsThroughComments() {
        }

        private static Set<J> find(J.Switch enclosingSwitch, J.Case scope) {
            HashSet<J> references = new HashSet<J>();
            new FindLastLineBreaksOrFallsThroughCommentsVisitor(scope).visit((Tree)enclosingSwitch, references);
            return references;
        }

        private static class FindLastLineBreaksOrFallsThroughCommentsVisitor
        extends JavaIsoVisitor<Set<J>> {
            private static final Predicate<Comment> HAS_RELIEF_PATTERN_COMMENT = comment -> comment instanceof TextComment && RELIEF_PATTERN.matcher(((TextComment)comment).getText()).find();
            private final J.Case scope;

            public FindLastLineBreaksOrFallsThroughCommentsVisitor(J.Case scope) {
                this.scope = scope;
            }

            private static boolean lastLineBreaksOrFallsThrough(List<? extends Statement> trees) {
                return trees.stream().reduce((s1, s2) -> s2).map(s -> FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks(s) || s.getComments().stream().anyMatch(HAS_RELIEF_PATTERN_COMMENT) || s instanceof J.Block && ((J.Block)s).getEnd().getComments().stream().anyMatch(HAS_RELIEF_PATTERN_COMMENT)).orElse(false);
            }

            private static boolean breaks(Statement s) {
                if (s instanceof J.Block) {
                    List statements = ((J.Block)s).getStatements();
                    return !statements.isEmpty() && FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks((Statement)statements.get(statements.size() - 1));
                }
                if (s instanceof J.If) {
                    J.If iff = (J.If)s;
                    return iff.getElsePart() != null && FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks(iff.getThenPart()) && FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks(iff.getThenPart());
                }
                if (s instanceof J.Label) {
                    return FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks(((J.Label)s).getStatement());
                }
                if (s instanceof J.Try) {
                    J.Try try_ = (J.Try)s;
                    if (try_.getFinally() != null && FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks((Statement)try_.getFinally())) {
                        return true;
                    }
                    if (!FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks((Statement)try_.getBody())) {
                        return false;
                    }
                    for (J.Try.Catch c : try_.getCatches()) {
                        if (FindLastLineBreaksOrFallsThroughCommentsVisitor.breaks((Statement)c.getBody())) continue;
                        return false;
                    }
                    return true;
                }
                return s instanceof J.Return || s instanceof J.Break || s instanceof J.Continue || s instanceof J.Throw || s instanceof J.Switch;
            }

            public J.Switch visitSwitch(J.Switch switch_, Set<J> ctx) {
                J.Switch s = super.visitSwitch(switch_, ctx);
                List statements = s.getCases().getStatements();
                for (int i = 0; i < statements.size() - 1; ++i) {
                    J.Case case_;
                    if (!(statements.get(i) instanceof J.Case) || (case_ = (J.Case)statements.get(i)) != this.scope || !((Statement)statements.get(i + 1)).getPrefix().getComments().stream().anyMatch(HAS_RELIEF_PATTERN_COMMENT)) continue;
                    ctx.add((J)s);
                }
                return s;
            }

            public J.Case visitCase(J.Case case_, Set<J> ctx) {
                if (case_ == this.scope && (case_.getStatements().isEmpty() || FindLastLineBreaksOrFallsThroughCommentsVisitor.lastLineBreaksOrFallsThrough(case_.getStatements()))) {
                    ctx.add((J)case_);
                }
                return case_;
            }
        }
    }

    private static class AddBreak<P>
    extends JavaIsoVisitor<P> {
        private final J.Case scope;

        public AddBreak(J.Case scope) {
            this.scope = scope;
        }

        public J.Case visitCase(J.Case case_, P p) {
            if (this.scope.isScope((Tree)case_)) {
                List statements = case_.getStatements();
                if (statements.size() == 1 && statements.get(0) instanceof J.Block) {
                    return super.visitCase(case_, p);
                }
                J.Break breakToAdd = (J.Break)this.autoFormat((J)new J.Break(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null), p);
                statements.add(breakToAdd);
                return case_.withStatements(ListUtils.map((List)statements, stmt -> (Statement)this.autoFormat((J)stmt, p, this.getCursor())));
            }
            return case_;
        }

        public J.Block visitBlock(J.Block block, P p) {
            J.Block b = block;
            if (this.getCursor().isScopeInPath((Tree)this.scope)) {
                List statements = b.getStatements();
                if (statements.size() == 1 && statements.get(0) instanceof J.Block) {
                    return super.visitBlock(b, p);
                }
                J.Break breakToAdd = (J.Break)this.autoFormat((J)new J.Break(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null), p);
                statements.add(breakToAdd);
                b = b.withStatements(ListUtils.map((List)statements, stmt -> (Statement)this.autoFormat((J)stmt, p, this.getCursor())));
            }
            return b;
        }
    }
}

