/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.OperatorWrapStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.TypeTree;

public class OperatorWrap
extends Recipe {
    public String getDisplayName() {
        return "Operator wrapping";
    }

    public String getDescription() {
        return "Fixes line wrapping policies on operators.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new OperatorWrapVisitor();
    }

    private static class OperatorWrapVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        OperatorWrapStyle operatorWrapStyle;

        private OperatorWrapVisitor() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                this.operatorWrapStyle = cu.getStyle(OperatorWrapStyle.class) == null ? Checkstyle.operatorWrapStyle() : (OperatorWrapStyle)cu.getStyle(OperatorWrapStyle.class);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
            J.Binary b = super.visitBinary(binary, (Object)ctx);
            J.Binary.Type op = b.getOperator();
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getDiv()) && op == J.Binary.Type.Division || Boolean.TRUE.equals(this.operatorWrapStyle.getStar()) && op == J.Binary.Type.Multiplication || Boolean.TRUE.equals(this.operatorWrapStyle.getPlus()) && op == J.Binary.Type.Addition || Boolean.TRUE.equals(this.operatorWrapStyle.getMinus()) && op == J.Binary.Type.Subtraction || Boolean.TRUE.equals(this.operatorWrapStyle.getMod()) && op == J.Binary.Type.Modulo || Boolean.TRUE.equals(this.operatorWrapStyle.getSr()) && op == J.Binary.Type.RightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getSl()) && op == J.Binary.Type.LeftShift || Boolean.TRUE.equals(this.operatorWrapStyle.getBsr()) && op == J.Binary.Type.UnsignedRightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getEqual()) && op == J.Binary.Type.Equal || Boolean.TRUE.equals(this.operatorWrapStyle.getNotEqual()) && op == J.Binary.Type.NotEqual || Boolean.TRUE.equals(this.operatorWrapStyle.getGt()) && op == J.Binary.Type.GreaterThan || Boolean.TRUE.equals(this.operatorWrapStyle.getGe()) && op == J.Binary.Type.GreaterThanOrEqual || Boolean.TRUE.equals(this.operatorWrapStyle.getLt()) && op == J.Binary.Type.LessThan || Boolean.TRUE.equals(this.operatorWrapStyle.getLe()) && op == J.Binary.Type.LessThanOrEqual || Boolean.TRUE.equals(this.operatorWrapStyle.getBand()) && op == J.Binary.Type.BitAnd || Boolean.TRUE.equals(this.operatorWrapStyle.getBxor()) && op == J.Binary.Type.BitXor || Boolean.TRUE.equals(this.operatorWrapStyle.getBor()) && op == J.Binary.Type.BitOr || Boolean.TRUE.equals(this.operatorWrapStyle.getLand()) && op == J.Binary.Type.And || Boolean.TRUE.equals(this.operatorWrapStyle.getLor()) && op == J.Binary.Type.Or) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (b.getRight().getPrefix().getWhitespace().contains("\n")) {
                        b = b.getPadding().withOperator(b.getPadding().getOperator().withBefore(b.getRight().getPrefix()));
                        b = b.withRight((Expression)b.getRight().withPrefix(b.getRight().getPrefix().withWhitespace(" ")));
                    }
                } else if (b.getPadding().getOperator().getBefore().getWhitespace().contains("\n")) {
                    b = b.withRight((Expression)b.getRight().withPrefix(b.getPadding().getOperator().getBefore()));
                    b = b.getPadding().withOperator(b.getPadding().getOperator().withBefore(b.getRight().getPrefix().withWhitespace(" ")));
                }
            }
            return b;
        }

        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, ExecutionContext ctx) {
            J.TypeParameter tp = super.visitTypeParameter(typeParam, (Object)ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getTypeExtensionAnd()) && tp.getPadding().getBounds() != null) {
                int typeBoundsSize = tp.getPadding().getBounds().getPadding().getElements().size();
                tp = tp.getPadding().withBounds(tp.getPadding().getBounds().getPadding().withElements(ListUtils.map((List)tp.getPadding().getBounds().getPadding().getElements(), (index, elemContainer) -> {
                    JRightPadded previous;
                    if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                        if (index != typeBoundsSize - 1 && typeParam.getPadding().getBounds() != null) {
                            JRightPadded next = (JRightPadded)typeParam.getPadding().getBounds().getPadding().getElements().get(index + 1);
                            if (((TypeTree)next.getElement()).getPrefix().getWhitespace().contains("\n")) {
                                elemContainer = elemContainer.withAfter(((TypeTree)next.getElement()).getPrefix());
                            }
                        } else if (((TypeTree)elemContainer.getElement()).getPrefix().getWhitespace().contains("\n")) {
                            elemContainer = elemContainer.withElement((Object)((TypeTree)((TypeTree)elemContainer.getElement()).withPrefix(((TypeTree)elemContainer.getElement()).getPrefix().withWhitespace(" "))));
                        }
                    } else if (index != typeBoundsSize - 1) {
                        if (elemContainer.getAfter().getWhitespace().contains("\n")) {
                            elemContainer = elemContainer.withAfter(elemContainer.getAfter().withWhitespace(" "));
                        }
                    } else if (typeBoundsSize > 1 && typeParam.getPadding().getBounds() != null && (previous = (JRightPadded)typeParam.getPadding().getBounds().getPadding().getElements().get(index - 1)).getAfter().getWhitespace().contains("\n")) {
                        elemContainer = elemContainer.withElement((Object)((TypeTree)((TypeTree)elemContainer.getElement()).withPrefix(previous.getAfter())));
                    }
                    return elemContainer;
                })));
            }
            return tp;
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, ExecutionContext ctx) {
            J.InstanceOf i = super.visitInstanceOf(instanceOf, (Object)ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getLiteralInstanceof())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (i.getClazz().getPrefix().getWhitespace().contains("\n")) {
                        i = i.getPadding().withExpr(i.getPadding().getExpr().withAfter(i.getClazz().getPrefix()));
                        i = i.withClazz(i.getClazz().withPrefix(i.getClazz().getPrefix().withWhitespace(" ")));
                    }
                } else if (i.getPadding().getExpr().getAfter().getWhitespace().contains("\n")) {
                    i = i.withClazz(i.getClazz().withPrefix(i.getPadding().getExpr().getAfter()));
                    i = i.getPadding().withExpr(i.getPadding().getExpr().withAfter(i.getPadding().getExpr().getAfter().withWhitespace(" ")));
                }
            }
            return i;
        }

        public J.Ternary visitTernary(J.Ternary ternary, ExecutionContext ctx) {
            J.Ternary t = super.visitTernary(ternary, (Object)ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getQuestion())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (t.getTruePart().getPrefix().getWhitespace().contains("\n")) {
                        t = t.getPadding().withTruePart(t.getPadding().getTruePart().withBefore(((Expression)t.getPadding().getTruePart().getElement()).getPrefix()));
                        t = t.getPadding().withTruePart(t.getPadding().getTruePart().withElement((Object)((Expression)((Expression)t.getPadding().getTruePart().getElement()).withPrefix(((Expression)t.getPadding().getTruePart().getElement()).getPrefix().withWhitespace(" ")))));
                    }
                } else if (t.getPadding().getTruePart().getBefore().getWhitespace().contains("\n")) {
                    t = t.getPadding().withTruePart(t.getPadding().getTruePart().withElement((Object)((Expression)((Expression)t.getPadding().getTruePart().getElement()).withPrefix(t.getPadding().getTruePart().getBefore()))));
                    t = t.getPadding().withTruePart(t.getPadding().getTruePart().withBefore(((Expression)t.getPadding().getTruePart().getElement()).getPrefix().withWhitespace(" ")));
                }
            }
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getColon())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((Expression)t.getPadding().getFalsePart().getElement()).getPrefix().getWhitespace().contains("\n")) {
                        t = t.getPadding().withFalsePart(t.getPadding().getFalsePart().withBefore(((Expression)t.getPadding().getFalsePart().getElement()).getPrefix()));
                        t = t.getPadding().withFalsePart(t.getPadding().getFalsePart().withElement((Object)((Expression)((Expression)t.getPadding().getFalsePart().getElement()).withPrefix(((Expression)t.getPadding().getFalsePart().getElement()).getPrefix().withWhitespace(" ")))));
                    }
                } else if (t.getPadding().getFalsePart().getBefore().getWhitespace().contains("\n")) {
                    t = t.getPadding().withFalsePart(t.getPadding().getFalsePart().withElement((Object)((Expression)((Expression)t.getPadding().getFalsePart().getElement()).withPrefix(t.getPadding().getFalsePart().getBefore()))));
                    t = t.getPadding().withFalsePart(t.getPadding().getFalsePart().withBefore(((Expression)t.getPadding().getFalsePart().getElement()).getPrefix().withWhitespace(" ")));
                }
            }
            return t;
        }

        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
            J.MemberReference m = super.visitMemberReference(memberRef, (Object)ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getMethodRef())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (m.getPadding().getReference().getBefore().getWhitespace().contains("\n")) {
                        m = m.getPadding().withContaining(m.getPadding().getContaining().withAfter(m.getPadding().getReference().getBefore()));
                        m = m.getPadding().withReference(m.getPadding().getReference().withBefore(m.getPadding().getReference().getBefore().withWhitespace("")));
                    }
                } else if (m.getPadding().getContaining().getAfter().getWhitespace().contains("\n")) {
                    m = m.getPadding().withReference(m.getPadding().getReference().withBefore(m.getPadding().getContaining().getAfter()));
                    m = m.getPadding().withContaining(m.getPadding().getContaining().withAfter(m.getPadding().getReference().getBefore().withWhitespace("")));
                }
            }
            return m;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getAssign())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((Expression)a.getPadding().getAssignment().getElement()).getPrefix().getWhitespace().contains("\n")) {
                        a = a.getPadding().withAssignment(a.getPadding().getAssignment().withBefore(((Expression)a.getPadding().getAssignment().getElement()).getPrefix()));
                        a = a.getPadding().withAssignment(a.getPadding().getAssignment().withElement((Object)((Expression)((Expression)a.getPadding().getAssignment().getElement()).withPrefix(((Expression)a.getPadding().getAssignment().getElement()).getPrefix().withWhitespace(" ")))));
                    }
                } else if (a.getPadding().getAssignment().getBefore().getWhitespace().contains("\n")) {
                    a = a.getPadding().withAssignment(a.getPadding().getAssignment().withElement((Object)((Expression)((Expression)a.getPadding().getAssignment().getElement()).withPrefix(a.getPadding().getAssignment().getBefore()))));
                    a = a.getPadding().withAssignment(a.getPadding().getAssignment().withBefore(a.getPadding().getAssignment().getBefore().withWhitespace(" ")));
                }
            }
            return a;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, ExecutionContext ctx) {
            J.AssignmentOperation a = super.visitAssignmentOperation(assignOp, (Object)ctx);
            J.AssignmentOperation.Type op = a.getOperator();
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getPlusAssign()) && op == J.AssignmentOperation.Type.Addition || Boolean.TRUE.equals(this.operatorWrapStyle.getMinusAssign()) && op == J.AssignmentOperation.Type.Subtraction || Boolean.TRUE.equals(this.operatorWrapStyle.getStarAssign()) && op == J.AssignmentOperation.Type.Multiplication || Boolean.TRUE.equals(this.operatorWrapStyle.getDivAssign()) && op == J.AssignmentOperation.Type.Division || Boolean.TRUE.equals(this.operatorWrapStyle.getModAssign()) && op == J.AssignmentOperation.Type.Modulo || Boolean.TRUE.equals(this.operatorWrapStyle.getSrAssign()) && op == J.AssignmentOperation.Type.RightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getSlAssign()) && op == J.AssignmentOperation.Type.LeftShift || Boolean.TRUE.equals(this.operatorWrapStyle.getBsrAssign()) && op == J.AssignmentOperation.Type.UnsignedRightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getBandAssign()) && op == J.AssignmentOperation.Type.BitAnd || Boolean.TRUE.equals(this.operatorWrapStyle.getBxorAssign()) && op == J.AssignmentOperation.Type.BitXor || Boolean.TRUE.equals(this.operatorWrapStyle.getBorAssign()) && op == J.AssignmentOperation.Type.BitOr) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (a.getAssignment().getPrefix().getWhitespace().contains("\n")) {
                        a = a.getPadding().withOperator(a.getPadding().getOperator().withBefore(a.getAssignment().getPrefix()));
                        a = a.withAssignment((Expression)a.getAssignment().withPrefix(a.getAssignment().getPrefix().withWhitespace(" ")));
                    }
                } else if (a.getPadding().getOperator().getBefore().getWhitespace().contains("\n")) {
                    a = a.withAssignment((Expression)a.getAssignment().withPrefix(a.getPadding().getOperator().getBefore()));
                    a = a.getPadding().withOperator(a.getPadding().getOperator().withBefore(a.getAssignment().getPrefix().withWhitespace(" ")));
                }
            }
            return a;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getAssign()) && v.getPadding().getInitializer() != null) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((Expression)v.getPadding().getInitializer().getElement()).getPrefix().getWhitespace().contains("\n") && (v = v.getPadding().withInitializer(v.getPadding().getInitializer().withBefore(((Expression)v.getPadding().getInitializer().getElement()).getPrefix()))).getPadding().getInitializer() != null && v.getPadding().getInitializer().getElement() != null) {
                        v = v.getPadding().withInitializer(v.getPadding().getInitializer().withElement((Object)((Expression)((Expression)v.getPadding().getInitializer().getElement()).withPrefix(((Expression)v.getPadding().getInitializer().getElement()).getPrefix().withWhitespace(" ")))));
                    }
                } else if (v.getPadding().getInitializer().getBefore().getWhitespace().contains("\n") && (v = v.getPadding().withInitializer(v.getPadding().getInitializer().withElement((Object)((Expression)((Expression)v.getPadding().getInitializer().getElement()).withPrefix(v.getPadding().getInitializer().getBefore()))))).getPadding().getInitializer() != null && v.getPadding().getInitializer().getBefore() != null) {
                    v = v.getPadding().withInitializer(v.getPadding().getInitializer().withBefore(((Expression)v.getPadding().getInitializer().getElement()).getPrefix().withWhitespace(" ")));
                }
            }
            return v;
        }
    }
}

