/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis.java;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class MoveFieldAnnotationToType
extends Recipe {
    @Option(displayName="Annotation type", description="The type of annotation to move.", example="org.openrewrite..*", required=false)
    private final @Nullable String annotationType;

    public String getDisplayName() {
        return "Move annotation to type instead of field";
    }

    public String getDescription() {
        return "Annotations that could be applied to either a field or a type are better applied to the type, because similar annotations may be more restrictive, leading to compile errors like 'scoping construct cannot be annotated with type-use annotation' when migrating later.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String annotationTypeInput = this.annotationType == null ? "org.openrewrite..*" : this.annotationType;
        return Preconditions.check((TreeVisitor)new UsesType(annotationTypeInput, null), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final Pattern typePattern;
            {
                this.typePattern = Pattern.compile(StringUtils.aspectjNameToPattern((String)annotationTypeInput));
            }

            public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, ExecutionContext ctx) {
                J.AnnotatedType at = super.visitAnnotatedType(annotatedType, (Object)ctx);
                if (this.isQualifiedClass(at.getTypeExpression())) {
                    AtomicReference matchingAnnotation = new AtomicReference();
                    if ((at = at.withAnnotations(ListUtils.map((List)at.getAnnotations(), a -> {
                        if (this.matchesType((J.Annotation)a)) {
                            matchingAnnotation.set(a);
                            return null;
                        }
                        return a;
                    }))).getTypeExpression() != null && matchingAnnotation.get() != null) {
                        TypeTree te = this.annotateInnerClass(at.getTypeExpression(), (J.Annotation)matchingAnnotation.get());
                        if ((at = at.withTypeExpression(te)).getAnnotations().isEmpty() && !(this.getCursor().getParentTreeCursor().getValue() instanceof J.MethodDeclaration)) {
                            at = at.withTypeExpression((TypeTree)te.withPrefix(te.getPrefix().withWhitespace("")));
                        }
                        at = (J.AnnotatedType)this.autoFormat((J)at, (J)at.getTypeExpression(), ctx, this.getCursor().getParentOrThrow());
                    }
                }
                return at;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (this.isQualifiedClass(mv.getTypeExpression())) {
                    AtomicReference matchingAnnotation = new AtomicReference();
                    if ((mv = mv.withLeadingAnnotations(ListUtils.map((List)mv.getLeadingAnnotations(), a -> {
                        if (this.matchesType((J.Annotation)a)) {
                            matchingAnnotation.set(a);
                            return null;
                        }
                        return a;
                    }))).getTypeExpression() != null && matchingAnnotation.get() != null) {
                        TypeTree te = this.annotateInnerClass(mv.getTypeExpression(), (J.Annotation)matchingAnnotation.get());
                        if ((mv = mv.withTypeExpression(te)).getLeadingAnnotations().isEmpty()) {
                            mv = mv.withTypeExpression((TypeTree)te.withPrefix(te.getPrefix().withWhitespace("")));
                        }
                        mv = (J.VariableDeclarations)this.autoFormat((J)mv, (J)mv.getTypeExpression(), ctx, this.getCursor().getParentOrThrow());
                    }
                }
                return mv;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (this.isQualifiedClass(md.getReturnTypeExpression())) {
                    AtomicReference matchingAnnotation = new AtomicReference();
                    if ((md = md.withLeadingAnnotations(ListUtils.map((List)md.getLeadingAnnotations(), a -> {
                        if (this.matchesType((J.Annotation)a)) {
                            matchingAnnotation.set(a);
                            return null;
                        }
                        return a;
                    }))).getReturnTypeExpression() != null && matchingAnnotation.get() != null) {
                        TypeTree te = this.annotateInnerClass(md.getReturnTypeExpression(), (J.Annotation)matchingAnnotation.get());
                        if ((md = md.withReturnTypeExpression(te)).getLeadingAnnotations().isEmpty()) {
                            md = md.withReturnTypeExpression((TypeTree)te.withPrefix(te.getPrefix().withWhitespace("")));
                        }
                        md = (J.MethodDeclaration)this.autoFormat((J)md, (J)md.getReturnTypeExpression(), ctx, this.getCursor().getParentOrThrow());
                    }
                }
                return md;
            }

            private boolean matchesType(J.Annotation ann) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)ann.getType());
                return fq != null && this.typePattern.matcher(fq.getFullyQualifiedName()).matches();
            }

            private boolean isQualifiedClass(@Nullable TypeTree tree) {
                return tree instanceof J.FieldAccess || tree instanceof J.ParameterizedType && ((J.ParameterizedType)tree).getClazz() instanceof J.FieldAccess || tree instanceof J.ArrayType;
            }

            private TypeTree annotateInnerClass(TypeTree qualifiedClassRef, J.Annotation annotation) {
                if (qualifiedClassRef instanceof J.FieldAccess) {
                    J.FieldAccess q = (J.FieldAccess)qualifiedClassRef;
                    if ((q = q.withName(q.getName().withAnnotations(ListUtils.concat((Object)annotation.withPrefix(Space.EMPTY), (List)q.getName().getAnnotations())))).getName().getPrefix().getWhitespace().isEmpty()) {
                        q = q.withName(q.getName().withPrefix(q.getName().getPrefix().withWhitespace(" ")));
                    }
                    return q;
                }
                if (qualifiedClassRef instanceof J.ParameterizedType && ((J.ParameterizedType)qualifiedClassRef).getClazz() instanceof TypeTree) {
                    J.ParameterizedType pt = (J.ParameterizedType)qualifiedClassRef;
                    return pt.withClazz((NameTree)this.annotateInnerClass((TypeTree)pt.getClazz(), annotation));
                }
                if (qualifiedClassRef instanceof J.ArrayType) {
                    J.ArrayType at = (J.ArrayType)qualifiedClassRef;
                    at = at.withAnnotations(ListUtils.concat((Object)annotation.withPrefix(Space.SINGLE_SPACE), (List)at.getAnnotations()));
                    return at;
                }
                return qualifiedClassRef;
            }
        });
    }

    @Generated
    public MoveFieldAnnotationToType(@Nullable String annotationType) {
        this.annotationType = annotationType;
    }

    @Generated
    public @Nullable String getAnnotationType() {
        return this.annotationType;
    }

    @Generated
    public String toString() {
        return "MoveFieldAnnotationToType(annotationType=" + this.getAnnotationType() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveFieldAnnotationToType)) {
            return false;
        }
        MoveFieldAnnotationToType other = (MoveFieldAnnotationToType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MoveFieldAnnotationToType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        return result;
    }
}

