/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.InvertCondition;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Loop;

public class NoRedundantJumpStatements
extends Recipe {
    public String getDisplayName() {
        return "Jump statements should not be redundant";
    }

    public String getDescription() {
        return "Jump statements such as return and continue let you change the default flow of program execution, but jump statements that direct the control flow to the original direction are just a waste of keystrokes.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3626");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.If visitIf(J.If iff, ExecutionContext ctx) {
                J.If i = super.visitIf(iff, (Object)ctx);
                boolean thenIsOnlyContinue = i.getThenPart() instanceof J.Continue;
                if (i.getThenPart() instanceof J.Block) {
                    J.Block then = (J.Block)i.getThenPart();
                    boolean bl = thenIsOnlyContinue = then.getStatements().size() == 1 && then.getStatements().get(0) instanceof J.Continue;
                }
                if (this.getCursor().getParentOrThrow().getParentOrThrow().getValue() instanceof J.Block) {
                    J.Block loopBlock;
                    Loop loop;
                    J enclosing = (J)this.getCursor().dropParentUntil(J.Block.class::isInstance).getParentTreeCursor().getValue();
                    if (enclosing instanceof Loop && thenIsOnlyContinue && i.getElsePart() != null && !(i.getElsePart().getBody() instanceof J.If) && (loop = (Loop)enclosing).getBody() instanceof J.Block && (loopBlock = (J.Block)loop.getBody()).getStatements().get(loopBlock.getStatements().size() - 1) == i) {
                        i = i.withIfCondition(InvertCondition.invert((J.ControlParentheses)i.getIfCondition(), (Cursor)this.getCursor())).withThenPart(i.getElsePart().getBody()).withElsePart(null);
                    }
                }
                return i;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                JavaType.Method methodType = m.getMethodType();
                if (m.getBody() != null && methodType != null && JavaType.Primitive.Void.equals((Object)methodType.getReturnType())) {
                    return m.withBody(m.getBody().withStatements(ListUtils.mapLast((List)m.getBody().getStatements(), s -> s instanceof J.Return ? null : s)));
                }
                return m;
            }
        };
    }
}

