/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NonNullApi
public class BigDecimalDoubleConstructorRecipe
extends Recipe {
    public String getDisplayName() {
        return "`new BigDecimal(double)` should not be used";
    }

    public String getDescription() {
        return "Use of `new BigDecimal(double)` constructor can lead to loss of precision. Use `BigDecimal.valueOf(double)` instead.\nFor example writing `new BigDecimal(0.1)` does not create a `BigDecimal` which is exactly equal to `0.1`, but it is equal to `0.1000000000000000055511151231257827021181583404541015625`. This is because `0.1` cannot be represented exactly as a double (or, for that matter, as a binary fraction of any finite length).";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2111");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            final JavaTemplate bigDecimalDoubleConstructor = JavaTemplate.builder((String)"new java.math.BigDecimal(#{d:any(double)})").build();
            final JavaTemplate bigDecimalValueOf = JavaTemplate.builder((String)"java.math.BigDecimal.valueOf(#{d:any(double)})").build();

            public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher = this.bigDecimalDoubleConstructor.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.bigDecimalValueOf.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitNewClass(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesMethod("java.math.BigDecimal <constructor>(..)")}), (TreeVisitor)javaVisitor);
    }
}

