/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.staticanalysis.FinalClassVisitor;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class FinalClass
extends Recipe {
    public String getDisplayName() {
        return "Finalize classes with private constructors";
    }

    public String getDescription() {
        return "Adds the `final` modifier to classes that expose no public or package-private constructors.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2974");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new FinalClassVisitor());
    }
}

