/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoToStringOnStringType
extends Recipe {
    private static final MethodMatcher TO_STRING = new MethodMatcher("java.lang.String toString()");

    public String getDisplayName() {
        return "Unnecessary String#toString()";
    }

    public String getDescription() {
        return "Remove unnecessary `String#toString()` invocations on objects which are already a string.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1858");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(TO_STRING), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (mi.getSelect() != null && TO_STRING.matches((MethodCall)mi)) {
                    return mi.getSelect().withPrefix(mi.getPrefix());
                }
                return mi;
            }
        });
    }
}

