/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.CustomImportOrderStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.CustomImportOrderVisitor;
import org.openrewrite.style.Style;

public class CustomImportOrder
extends Recipe {
    public String getDisplayName() {
        return "Custom import order";
    }

    public String getDescription() {
        return "Updates and reorders Java import declarations according to group and order settings compatible with the Checkstyle 'CustomImportOrder' check.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CustomImportOrderCompilationUnitStyle();
    }

    private static class CustomImportOrderCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private CustomImportOrderCompilationUnitStyle() {
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            JavaSourceFile cu;
            CustomImportOrderStyle style;
            if (tree instanceof JavaSourceFile && (style = (CustomImportOrderStyle)Style.from(CustomImportOrderStyle.class, (SourceFile)(cu = (JavaSourceFile)Objects.requireNonNull(tree)))) != null) {
                return (J)new CustomImportOrderVisitor(style).visitNonNull((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

