/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypedTree;

public class RemoveToStringCallsFromArrayInstances
extends Recipe {
    private static final MethodMatcher VALUEOF_MATCHER = new MethodMatcher("java.lang.String valueOf(java.lang.Object)");
    private static final MethodMatcher OBJECTS_TOSTRING_MATCHER = new MethodMatcher("java.util.Objects toString(Object)");
    private static final MethodMatcher TOSTRING_MATCHER = new MethodMatcher("java.lang.Object toString()");
    private static final List<String> PATTERNS = Arrays.asList("java.io.PrintStream print*(Object)", "java.lang.String format*(..)", "java.lang.StringBuilder insert(int, Object)", "java.lang.StringBuilder append(Object)", "java.io.PrintStream format(String, Object[])", "java.io.PrintWriter print*(..)", "java.io.PrintWriter format(..)");
    private static final List<MethodMatcher> METHOD_MATCHERS = PATTERNS.stream().map(MethodMatcher::new).collect(Collectors.toList());

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2116");
    }

    public String getDisplayName() {
        return "Remove `toString()` calls on arrays";
    }

    public String getDescription() {
        return "The result from `toString()` calls on arrays is largely useless. The output does not actually reflect the contents of the array. `Arrays.toString(array)` should be used instead as it gives the contents of the array.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveToStringFromArraysVisitor();
    }

    private static class RemoveToStringFromArraysVisitor
    extends JavaVisitor<ExecutionContext> {
        private RemoveToStringFromArraysVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
            if (TOSTRING_MATCHER.matches((MethodCall)mi)) {
                Expression select = mi.getSelect();
                if (select == null) {
                    return mi;
                }
                return this.buildReplacement(select, mi);
            }
            if (METHOD_MATCHERS.stream().anyMatch(matcher -> matcher.matches((MethodCall)mi))) {
                JavaType.Method methodType = mi.getMethodType();
                if (methodType == null) {
                    return mi;
                }
                List parameterTypes = methodType.getParameterTypes();
                List arguments = mi.getArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    Expression arg = (Expression)arguments.get(i);
                    if (!(arg.getType() instanceof JavaType.Array) || i <= parameterTypes.size() - 1 && parameterTypes.get(i) instanceof JavaType.Array) continue;
                    this.getCursor().putMessage("METHOD_KEY", (Object)mi);
                    break;
                }
            } else if (OBJECTS_TOSTRING_MATCHER.matches((MethodCall)mi) || VALUEOF_MATCHER.matches((MethodCall)mi)) {
                Expression select = (Expression)mi.getArguments().get(0);
                this.maybeRemoveImport("java.util.Objects");
                return this.buildReplacement(select, mi);
            }
            return super.visitMethodInvocation(mi, (Object)ctx);
        }

        public J buildReplacement(Expression select, J.MethodInvocation mi) {
            if (!(select.getType() instanceof JavaType.Array)) {
                return mi;
            }
            this.maybeAddImport("java.util.Arrays");
            return JavaTemplate.builder((String)"Arrays.toString(#{anyArray(java.lang.Object)})").imports(new String[]{"java.util.Arrays"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{select});
        }

        public Expression visitExpression(Expression exp, ExecutionContext ctx) {
            Cursor c;
            Expression e = (Expression)super.visitExpression(exp, (Object)ctx);
            if (e instanceof TypedTree && e.getType() instanceof JavaType.Array && ((c = this.getCursor().dropParentWhile(is -> is instanceof J.Parentheses || !(is instanceof Tree))).getMessage("METHOD_KEY") != null || c.getMessage("BINARY_FOUND") != null)) {
                this.maybeAddImport("java.util.Arrays");
                return (Expression)JavaTemplate.builder((String)"Arrays.toString(#{anyArray(java.lang.Object)})").imports(new String[]{"java.util.Arrays"}).build().apply(this.getCursor(), e.getCoordinates().replace(), new Object[]{e});
            }
            return e;
        }

        public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
            Expression left = binary.getLeft();
            Expression right = binary.getRight();
            if (binary.getOperator() == J.Binary.Type.Addition && (left.getType() instanceof JavaType.Array || right.getType() instanceof JavaType.Array)) {
                this.getCursor().putMessage("BINARY_FOUND", (Object)binary);
            }
            return (J.Binary)super.visitBinary(binary, (Object)ctx);
        }
    }
}

