/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.csharp.CSharpFileChecker;

public class UseJavaStyleArrayDeclarations
extends Recipe {
    public String getDisplayName() {
        return "No C-style array declarations";
    }

    public String getDescription() {
        return "Change C-Style array declarations `int i[];` to `int[] i;`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1197");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new CSharpFileChecker()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations varDecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                List dimensions = (List)this.getCursor().pollMessage("VAR_DIMENSIONS");
                if (dimensions != null && varDecls.getTypeExpression() != null) {
                    TypeTree typeExpression = varDecls.getTypeExpression();
                    JavaType type = varDecls.getType();
                    for (JLeftPadded dim : dimensions) {
                        type = new JavaType.Array(null, type, null);
                        typeExpression = new J.ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, typeExpression, null, dim, type);
                    }
                    varDecls = varDecls.withTypeExpression(typeExpression);
                }
                return varDecls;
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                J.VariableDeclarations.NamedVariable nv = super.visitVariable(variable, (Object)ctx);
                if (!nv.getDimensionsAfterName().isEmpty()) {
                    this.getCursor().dropParentUntil(J.VariableDeclarations.class::isInstance).putMessage("VAR_DIMENSIONS", (Object)nv.getDimensionsAfterName());
                    nv = nv.withDimensionsAfterName(Collections.emptyList());
                }
                return nv;
            }
        });
    }
}

