/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.EmptyBlockVisitor;

public class EmptyBlock
extends Recipe {
    public String getDisplayName() {
        return "Remove empty blocks";
    }

    public String getDescription() {
        return "Remove empty blocks that effectively do nothing.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S108");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EmptyBlockFromCompilationUnitStyle();
    }

    private static class EmptyBlockFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private EmptyBlockFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                EmptyBlockStyle style = (EmptyBlockStyle)cu.getStyle(EmptyBlockStyle.class);
                if (style == null) {
                    style = Checkstyle.emptyBlock();
                }
                return (J)new EmptyBlockVisitor(style).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

