/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class ForLoopIncrementInUpdate
extends Recipe {
    public String getDisplayName() {
        return "`for` loop counters incremented in update";
    }

    public String getDescription() {
        return "The increment should be moved to the loop's increment clause if possible.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1994");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(20L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
                Statement init = (Statement)forLoop.getControl().getInit().get(0);
                if (init instanceof J.VariableDeclarations) {
                    J.Unary unary;
                    List statements;
                    J.VariableDeclarations initVars = (J.VariableDeclarations)init;
                    Statement body = forLoop.getBody();
                    if (body instanceof J.Block) {
                        statements = ((J.Block)body).getStatements();
                        if (statements.isEmpty()) {
                            return super.visitForLoop(forLoop, (Object)ctx);
                        }
                    } else {
                        return super.visitForLoop(forLoop, (Object)ctx);
                    }
                    Statement lastStatement = (Statement)statements.get(statements.size() - 1);
                    if (lastStatement instanceof J.Unary && (unary = (J.Unary)lastStatement).getExpression() instanceof J.Identifier) {
                        String unaryTarget = ((J.Identifier)unary.getExpression()).getSimpleName();
                        for (J.VariableDeclarations.NamedVariable initVar : initVars.getVariables()) {
                            if (!initVar.getSimpleName().equals(unaryTarget)) continue;
                            J.ForLoop f = forLoop.withControl(forLoop.getControl().withUpdate(ListUtils.insertInOrder((List)ListUtils.map((List)forLoop.getControl().getUpdate(), u -> u instanceof J.Empty ? null : u), (Object)unary.withPrefix(Space.format((String)" ")), Comparator.comparing(s -> s.printTrimmed(this.getCursor()), Comparator.naturalOrder()))));
                            return f.withBody((Statement)new JavaVisitor<ExecutionContext>(){

                                public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                                    return tree == unary ? null : (J)super.visit(tree, (Object)ctx);
                                }
                            }.visit((Tree)f.getBody(), ctx));
                        }
                    }
                }
                return super.visitForLoop(forLoop, (Object)ctx);
            }
        };
    }
}

