/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class RemoveRedundantNullCheckBeforeInstanceof
extends Recipe {
    public String getDisplayName() {
        return "Remove redundant null checks before instanceof";
    }

    public String getDescription() {
        return "Removes redundant null checks before instanceof operations since instanceof returns false for null.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1697");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new KotlinFileChecker()), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                J.InstanceOf instanceOf;
                J.Binary nullCheck;
                J.Binary bi = (J.Binary)super.visitBinary(binary, (Object)ctx);
                if (bi.getOperator() != J.Binary.Type.And) {
                    return bi;
                }
                Expression left = bi.getLeft();
                Expression right = bi.getRight();
                if (left instanceof J.Binary && right instanceof J.InstanceOf && this.isRedundantNullCheck(nullCheck = (J.Binary)left, instanceOf = (J.InstanceOf)right)) {
                    return instanceOf.withPrefix(bi.getPrefix());
                }
                if (left instanceof J.Binary && ((J.Binary)left).getOperator() == J.Binary.Type.And && right instanceof J.InstanceOf) {
                    J.Binary leftBinary = (J.Binary)left;
                    instanceOf = (J.InstanceOf)right;
                    Expression rightmostOfLeft = leftBinary.getRight();
                    if (rightmostOfLeft instanceof J.Binary && this.isRedundantNullCheck((J.Binary)rightmostOfLeft, instanceOf)) {
                        return bi.withLeft(leftBinary.getLeft()).withRight((Expression)instanceOf);
                    }
                }
                return bi;
            }

            private boolean isRedundantNullCheck(J.Binary nullCheck, J.InstanceOf instanceOf) {
                if (nullCheck.getOperator() == J.Binary.Type.NotEqual) {
                    if (J.Literal.isLiteralValue((Expression)nullCheck.getLeft(), null)) {
                        return SemanticallyEqual.areEqual((J)nullCheck.getRight(), (J)instanceOf.getExpression());
                    }
                    if (J.Literal.isLiteralValue((Expression)nullCheck.getRight(), null)) {
                        return SemanticallyEqual.areEqual((J)nullCheck.getLeft(), (J)instanceOf.getExpression());
                    }
                }
                return false;
            }
        });
    }

    @Generated
    public RemoveRedundantNullCheckBeforeInstanceof() {
    }

    @Generated
    public String toString() {
        return "RemoveRedundantNullCheckBeforeInstanceof()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantNullCheckBeforeInstanceof)) {
            return false;
        }
        RemoveRedundantNullCheckBeforeInstanceof other = (RemoveRedundantNullCheckBeforeInstanceof)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveRedundantNullCheckBeforeInstanceof;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

